/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.RecoveryPoint;
import com.crankuptheamps.client.RecoveryPointAdapter;
import com.crankuptheamps.client.fields.Field;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConflatingRecoveryPointAdapter
implements RecoveryPointAdapter {
    protected RecoveryPointAdapter _adapter = null;
    protected final ConcurrentHashMap<Field, Long> _counts = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Field, Long> _timers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Field, RecoveryPoint> _latestUpdates = new ConcurrentHashMap();
    protected volatile long _updateThreshold = 10L;
    protected volatile long _timeoutMillis = 2000L;
    protected volatile long _updateIntervalMillis = 2000L;
    protected UpdateThread _thread = null;
    protected volatile boolean _closed = false;
    protected volatile boolean _updateAll = false;
    protected volatile ExceptionListener _exceptionListener = null;
    private final Lock lock = new ReentrantLock();
    private final Condition _updatesReady = this.lock.newCondition();

    public ConflatingRecoveryPointAdapter(RecoveryPointAdapter adapter) {
        this._adapter = adapter;
        this._thread = new UpdateThread("ConflatingRecoveryPointAdapter" + CommandId.nextIdentifier());
        this._thread.start();
    }

    public ConflatingRecoveryPointAdapter(RecoveryPointAdapter adapter, long updateThreshold, long timeoutMillis, long updateIntervalMillis) {
        this._adapter = adapter;
        this._updateThreshold = updateThreshold;
        this._timeoutMillis = timeoutMillis;
        this._updateIntervalMillis = updateIntervalMillis;
        this._thread = new UpdateThread("ConflatingRecoveryPointAdapter" + CommandId.nextIdentifier());
        this._thread.start();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this._exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this._exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(RecoveryPoint recoveryPoint) {
        RecoveryPoint rpCopy = recoveryPoint.copy();
        Field subId = recoveryPoint.getSubId();
        this.lock.lock();
        try {
            if (this._latestUpdates.replace(subId, rpCopy) != null) {
                long count = this._counts.get(subId);
                this._counts.put(subId, ++count);
                if (count >= this._updateThreshold) {
                    this._updatesReady.signalAll();
                }
            } else {
                this._latestUpdates.put(subId.copy(), rpCopy);
                this._counts.put(subId.copy(), 1L);
                if (this._timeoutMillis != 0L) {
                    this._timers.put(subId.copy(), System.currentTimeMillis());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void purge() throws Exception {
        this.lock.lock();
        try {
            if (this._adapter != null) {
                this.runUpdateAll();
                this._adapter.purge();
            }
            this._latestUpdates.clear();
            this._counts.clear();
            this._timers.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void purge(Field subId) throws Exception {
        this.lock.lock();
        try {
            if (this._adapter != null) {
                this.runUpdateAll();
                this._adapter.purge(subId);
            }
            this._latestUpdates.remove(subId);
            this._counts.remove(subId);
            this._timers.remove(subId);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
        this.lock.lock();
        try {
            if (!this._closed) {
                this.runUpdateAll();
                this._closed = true;
                this._updatesReady.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this._thread != null) {
            this._thread.join();
            this._thread = null;
        }
        if (this._adapter != null) {
            this._adapter.close();
        }
    }

    @Override
    public boolean hasNext() {
        return this._adapter.hasNext();
    }

    @Override
    public RecoveryPoint next() {
        return (RecoveryPoint)this._adapter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<RecoveryPoint> iterator() {
        return this;
    }

    public void updateAll() {
        this.lock.lock();
        try {
            this.runUpdateAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void runUpdateAll() {
        this._updateAll = true;
        while (!this._counts.isEmpty()) {
            this._updatesReady.signalAll();
            try {
                this._updatesReady.await(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (this._exceptionListener == null) continue;
                this._exceptionListener.exceptionThrown(e);
            }
        }
    }

    protected class UpdateThread
    extends Thread {
        protected ArrayList<RecoveryPoint> _updates;

        public UpdateThread(String threadName) {
            super(threadName);
            this._updates = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean closed = ConflatingRecoveryPointAdapter.this._closed;
            while (!closed) {
                try {
                    boolean updateAll;
                    ConflatingRecoveryPointAdapter.this.lock.lock();
                    try {
                        Field subId;
                        ConflatingRecoveryPointAdapter.this._updatesReady.await(ConflatingRecoveryPointAdapter.this._updateIntervalMillis, TimeUnit.MILLISECONDS);
                        updateAll = ConflatingRecoveryPointAdapter.this._updateAll;
                        if (!updateAll) {
                            long now = System.currentTimeMillis();
                            for (Map.Entry<Field, Long> entry : ConflatingRecoveryPointAdapter.this._timers.entrySet()) {
                                Field subId2;
                                RecoveryPoint update;
                                if (entry.getValue() + ConflatingRecoveryPointAdapter.this._timeoutMillis < now || (update = ConflatingRecoveryPointAdapter.this._latestUpdates.get(subId2 = entry.getKey())) == null) continue;
                                ConflatingRecoveryPointAdapter.this._latestUpdates.remove(subId2);
                                this._updates.add(update);
                            }
                        }
                        for (Map.Entry<Field, Long> entry : ConflatingRecoveryPointAdapter.this._counts.entrySet()) {
                            RecoveryPoint update;
                            if (!updateAll && entry.getValue() < ConflatingRecoveryPointAdapter.this._updateThreshold || (update = ConflatingRecoveryPointAdapter.this._latestUpdates.get(subId = entry.getKey())) == null) continue;
                            ConflatingRecoveryPointAdapter.this._latestUpdates.remove(subId);
                            this._updates.add(update);
                        }
                        for (RecoveryPoint rp : this._updates) {
                            subId = rp.getSubId();
                            ConflatingRecoveryPointAdapter.this._counts.remove(subId);
                            ConflatingRecoveryPointAdapter.this._timers.remove(subId);
                        }
                        closed = ConflatingRecoveryPointAdapter.this._closed;
                    }
                    finally {
                        ConflatingRecoveryPointAdapter.this.lock.unlock();
                    }
                    if (updateAll) {
                        ConflatingRecoveryPointAdapter.this.lock.lock();
                    }
                    try {
                        for (RecoveryPoint update : this._updates) {
                            ConflatingRecoveryPointAdapter.this._adapter.update(update);
                        }
                    }
                    catch (Exception e) {
                        if (ConflatingRecoveryPointAdapter.this._exceptionListener != null) {
                            ConflatingRecoveryPointAdapter.this._exceptionListener.exceptionThrown(e);
                        }
                    }
                    finally {
                        if (updateAll) {
                            ConflatingRecoveryPointAdapter.this._updateAll = false;
                            ConflatingRecoveryPointAdapter.this._updatesReady.signalAll();
                            ConflatingRecoveryPointAdapter.this.lock.unlock();
                        }
                    }
                    this._updates.clear();
                }
                catch (Exception e) {
                    if (ConflatingRecoveryPointAdapter.this._exceptionListener == null) continue;
                    ConflatingRecoveryPointAdapter.this._exceptionListener.exceptionThrown(e);
                }
            }
        }
    }
}

