/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Subscription;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.fields.AckTypeField;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.CommandField;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.IntegerField;
import com.crankuptheamps.client.fields.LongField;
import com.crankuptheamps.client.fields.OptionsField;
import com.crankuptheamps.client.fields.ReasonField;
import com.crankuptheamps.client.fields.StatusField;
import com.crankuptheamps.client.fields.StringField;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

public abstract class Message {
    protected final CharsetEncoder encoder;
    protected final CharsetDecoder decoder;
    static final int MINIMUM_SERVER_VERSION = 99999999;
    private long _bookmarkSeqNo = 0L;
    private Subscription _subscription = null;
    private byte[] buffer = null;
    private int _rawBufferOffset = 0;
    private int _rawBufferLength = 0;
    protected final AckTypeField _AckType = new AckTypeField();
    protected final IntegerField _BatchSize = new IntegerField();
    protected final BookmarkField _Bookmark = new BookmarkField();
    protected final StringField _ClientName = new StringField();
    protected final StringField _CommandId = new StringField();
    protected final CommandField _Command = new CommandField();
    protected final StringField _Data = new StringField();
    protected final IntegerField _Expiration = new IntegerField();
    protected final StringField _Filter = new StringField();
    protected final StringField _LeasePeriod = new StringField();
    protected final StringField _MessageType = new StringField();
    protected final StringField _OrderBy = new StringField();
    protected final LongField _GroupSeqNo = new LongField();
    protected final LongField _Matches = new LongField();
    protected final StringField _Password = new StringField();
    protected final IntegerField _Length = new IntegerField();
    protected final OptionsField _Options = new OptionsField();
    protected final StringField _QueryId = new StringField();
    protected final ReasonField _Reason = new ReasonField();
    protected final LongField _RecordsInserted = new LongField();
    protected final LongField _RecordsUpdated = new LongField();
    protected final LongField _RecordsDeleted = new LongField();
    protected final LongField _RecordsReturned = new LongField();
    protected final LongField _Sequence = new LongField();
    protected final StringField _SowKey = new StringField();
    protected final StringField _SowKeys = new StringField();
    protected final StatusField _Status = new StatusField();
    protected final StringField _SubId = new StringField();
    protected final StringField _SubIds = new StringField();
    protected final StringField _Timestamp = new StringField();
    protected final LongField _TopN = new LongField();
    protected final StringField _Topic = new StringField();
    protected final LongField _TopicMatches = new LongField();
    protected final StringField _UserId = new StringField();
    protected final StringField _Version = new StringField();
    protected final StringField _CorrelationId = new StringField();
    private final Object[][] _toStringFields = new Object[][]{{"Command"}};
    protected Client _client = null;
    private boolean _ignoreAutoAck = false;
    protected final Field[] _fields = new Field[]{this._AckType, this._BatchSize, this._Bookmark, this._ClientName, this._CommandId, this._Command, this._CorrelationId, this._Data, this._Expiration, this._Filter, this._OrderBy, this._GroupSeqNo, this._Length, this._LeasePeriod, this._Matches, this._MessageType, this._Options, this._QueryId, this._Reason, this._RecordsInserted, this._RecordsUpdated, this._RecordsDeleted, this._RecordsReturned, this._Sequence, this._SowKey, this._SowKeys, this._Status, this._SubId, this._SubIds, this._Timestamp, this._TopN, this._Topic, this._TopicMatches, this._UserId, this._Version, this._Password};

    protected Message(CharsetEncoder encoder, CharsetDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public CharsetEncoder getEncoder() {
        return this.encoder;
    }

    public CharsetDecoder getDecoder() {
        return this.decoder;
    }

    public void setBookmarkSeqNo(long val) {
        this._bookmarkSeqNo = val;
    }

    public long getBookmarkSeqNo() {
        return this._bookmarkSeqNo;
    }

    public void setSubscription(Subscription subscription) {
        this._subscription = subscription;
    }

    public Subscription getSubscription() {
        return this._subscription;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setRawBufferOffset(int offset) {
        this._rawBufferOffset = offset;
    }

    public int getRawBufferOffset() {
        return this._rawBufferOffset;
    }

    public void setRawBufferLength(int length) {
        this._rawBufferLength = length;
    }

    public int getRawBufferLength() {
        return this._rawBufferLength;
    }

    public abstract SerializationResult serialize(ByteBuffer var1);

    public Message reset() {
        for (Field f : this._fields) {
            f.reset();
        }
        this._bookmarkSeqNo = 0L;
        this._subscription = null;
        this._ignoreAutoAck = false;
        return this;
    }

    public int getAckType() {
        return this._AckType.getValue();
    }

    public int getAckTypeOutgoing() {
        if (this._AckType.isNull()) {
            return 0;
        }
        int ackType = 0;
        int len = 0;
        for (int start = this._AckType.position; start <= this._AckType.position + this._AckType.length; ++start) {
            if (start == this._AckType.position + this._AckType.length || this._AckType.buffer[start] == 44) {
                ackType |= AckTypeField.decodeAckType(this._AckType.buffer, start - len, len);
                len = 0;
                continue;
            }
            ++len;
        }
        return ackType;
    }

    public Message setAckType(int v) {
        this._AckType.setValue(v);
        return this;
    }

    public Message setAckType(String v) {
        this._AckType.set(v.getBytes(StandardCharsets.ISO_8859_1));
        return this;
    }

    public boolean isAckTypeNull() {
        return this._AckType.isNull();
    }

    public int getBatchSize() {
        return this._BatchSize.getValue();
    }

    public Message setBatchSize(int v) {
        this._BatchSize.setValue(v);
        return this;
    }

    public boolean isBatchSizeNull() {
        return this._BatchSize.isNull();
    }

    public String getBookmark() {
        return this._Bookmark.getValue(this.decoder);
    }

    public BookmarkField getBookmarkRaw() {
        return this._Bookmark;
    }

    public Message setBookmark(String v) {
        this._Bookmark.setValue(v, this.encoder);
        return this;
    }

    public Message setBookmark(byte[] buffer, int offset, int length) {
        this._Bookmark.setValue(buffer, offset, length);
        return this;
    }

    public boolean isBookmarkNull() {
        return this._Bookmark.isNull();
    }

    public String getClientName() {
        return this._ClientName.getValue(this.decoder);
    }

    public Field getClientNameRaw() {
        return this._ClientName;
    }

    public Message setClientName(String v) {
        this._ClientName.setValue(v, this.encoder);
        return this;
    }

    public Message setClientName(byte[] buffer, int offset, int length) {
        this._ClientName.setValue(buffer, offset, length);
        return this;
    }

    public boolean isClientNameNull() {
        return this._ClientName.isNull();
    }

    public String getCommandId() {
        return this._CommandId.getValue(this.decoder);
    }

    public Field getCommandIdRaw() {
        return this._CommandId;
    }

    public boolean getCommandId(CommandId v) {
        return this._CommandId.getValue(v);
    }

    public Message setCommandId(String v) {
        this._CommandId.setValue(v, this.encoder);
        return this;
    }

    public Message setCommandId(CommandId v) {
        this._CommandId.setValue(v);
        return this;
    }

    public Message setCommandId(byte[] buffer, int offset, int length) {
        this._CommandId.setValue(buffer, offset, length);
        return this;
    }

    public boolean isCommandIdNull() {
        return this._CommandId.isNull();
    }

    public int getCommand() {
        return this._Command.getValue();
    }

    public Message setCommand(int v) {
        this._Command.setValue(v);
        return this;
    }

    public Message setCommand(String v) {
        this._Command.set(v.getBytes(StandardCharsets.ISO_8859_1));
        return this;
    }

    public boolean isCommandNull() {
        return this._Command.isNull();
    }

    public String getData() {
        return this._Data.getValue(this.decoder);
    }

    public Field getDataRaw() {
        return this._Data;
    }

    public Message setData(String v) {
        this._Data.setValue(v, this.encoder);
        return this;
    }

    public Message setData(byte[] buffer, int offset, int length) {
        this._Data.setValue(buffer, offset, length);
        return this;
    }

    public boolean isDataNull() {
        return this._Data.isNull();
    }

    public int getExpiration() {
        return this._Expiration.getValue();
    }

    public IntegerField getExpirationRaw() {
        return this._Expiration;
    }

    public Message setExpiration(int v) {
        this._Expiration.setValue(v);
        return this;
    }

    public boolean isExpirationNull() {
        return this._Expiration.isNull();
    }

    public String getFilter() {
        return this._Filter.getValue(this.decoder);
    }

    public Field getFilterRaw() {
        return this._Filter;
    }

    public Message setFilter(String v) {
        this._Filter.setValue(v, this.encoder);
        return this;
    }

    public Message setFilter(byte[] buffer, int offset, int length) {
        this._Filter.setValue(buffer, offset, length);
        return this;
    }

    public boolean isFilterNull() {
        return this._Filter.isNull();
    }

    public boolean isLeasePeriodNull() {
        return this._LeasePeriod.isNull();
    }

    public String getLeasePeriod() {
        return this._LeasePeriod.getValue(this.decoder);
    }

    public StringField getLeasePeriodRaw() {
        return this._LeasePeriod;
    }

    public String getMessageType() {
        return this._MessageType.getValue(this.decoder);
    }

    public Message setMessageType(String v) {
        this._MessageType.setValue(v, this.encoder);
        return this;
    }

    public boolean isMessageTypeNull() {
        return this._MessageType.isNull();
    }

    public String getOrderBy() {
        return this._OrderBy.getValue(this.decoder);
    }

    public Field getOrderByRaw() {
        return this._OrderBy;
    }

    public Message setOrderBy(String v) {
        this._OrderBy.setValue(v, this.encoder);
        return this;
    }

    public Message setOrderBy(byte[] buffer, int offset, int length) {
        this._OrderBy.setValue(buffer, offset, length);
        return this;
    }

    public boolean isOrderByNull() {
        return this._OrderBy.isNull();
    }

    public long getGroupSeqNo() {
        return this._GroupSeqNo.getValue();
    }

    public Message setGroupSeqNo(long v) {
        this._GroupSeqNo.setValue(v);
        return this;
    }

    public boolean isGroupSeqNoNull() {
        return this._GroupSeqNo.isNull();
    }

    public long getMatches() {
        return this._Matches.getValue();
    }

    public Message setMatches(long v) {
        this._Matches.setValue(v);
        return this;
    }

    public boolean isMatchesNull() {
        return this._Matches.isNull();
    }

    public String getPassword() {
        return this._Password.getValue(this.decoder);
    }

    public Field getPasswordRaw() {
        return this._Password;
    }

    public Message setPassword(String v) {
        this._Password.setValue(v, this.encoder);
        return this;
    }

    public Message setPassword(byte[] buffer, int offset, int length) {
        this._Password.setValue(buffer, offset, length);
        return this;
    }

    public boolean isPasswordNull() {
        return this._Password.isNull();
    }

    public int getLength() {
        return this._Length.getValue();
    }

    public Message setLength(int v) {
        this._Length.setValue(v);
        return this;
    }

    public boolean isLengthNull() {
        return this._Length.isNull();
    }

    public String getOptions() {
        return this._Options.getValue(this.decoder);
    }

    public Field getOptionsRaw() {
        return this._Options;
    }

    public Message setOptions(String v) {
        this._Options.setValue(v, this.encoder);
        return this;
    }

    public boolean isOptionsNull() {
        return this._Options.isNull();
    }

    public String getQueryId() {
        return this._QueryId.getValue(this.decoder);
    }

    public Field getQueryIdRaw() {
        return this._QueryId;
    }

    public boolean getQueryId(CommandId v) {
        return this._QueryId.getValue(v);
    }

    public Message setQueryId(String v) {
        this._QueryId.setValue(v, this.encoder);
        return this;
    }

    public Message setQueryId(CommandId v) {
        this._QueryId.setValue(v);
        return this;
    }

    public Message setQueryId(byte[] buffer, int offset, int length) {
        this._QueryId.setValue(buffer, offset, length);
        return this;
    }

    public boolean isQueryIdNull() {
        return this._QueryId.isNull();
    }

    public int getReason() {
        return this._Reason.getValue();
    }

    public String getReasonText() {
        return this._Reason.getText();
    }

    public Message setReason(int v) {
        this._Reason.setValue(v);
        return this;
    }

    public boolean isReasonNull() {
        return this._Reason.isNull();
    }

    public long getRecordsInserted() {
        return this._RecordsInserted.getValue();
    }

    public Message setRecordsInserted(long v) {
        this._RecordsInserted.setValue(v);
        return this;
    }

    public boolean isRecordsInsertedNull() {
        return this._RecordsInserted.isNull();
    }

    public long getRecordsUpdated() {
        return this._RecordsUpdated.getValue();
    }

    public Message setRecordsUpdated(long v) {
        this._RecordsUpdated.setValue(v);
        return this;
    }

    public boolean isRecordsUpdatedNull() {
        return this._RecordsUpdated.isNull();
    }

    public long getRecordsDeleted() {
        return this._RecordsDeleted.getValue();
    }

    public Message setRecordsDeleted(long v) {
        this._RecordsDeleted.setValue(v);
        return this;
    }

    public boolean isRecordsDeletedNull() {
        return this._RecordsDeleted.isNull();
    }

    public long getRecordsReturned() {
        return this._RecordsReturned.getValue();
    }

    public Message setRecordsReturned(long v) {
        this._RecordsReturned.setValue(v);
        return this;
    }

    public boolean isRecordsReturnedNull() {
        return this._RecordsReturned.isNull();
    }

    public Field getSequenceRaw() {
        return this._Sequence;
    }

    public long getSequence() {
        return this._Sequence.getValue();
    }

    public Message setSequence(long v) {
        this._Sequence.setValue(v);
        return this;
    }

    public boolean isSequenceNull() {
        return this._Sequence.isNull();
    }

    public String getSowKey() {
        return this._SowKey.getValue(this.decoder);
    }

    public Field getSowKeyRaw() {
        return this._SowKey;
    }

    public Message setSowKey(String v) {
        this._SowKey.setValue(v, this.encoder);
        return this;
    }

    public Message setSowKey(byte[] buffer, int offset, int length) {
        this._SowKey.setValue(buffer, offset, length);
        return this;
    }

    public boolean isSowKeyNull() {
        return this._SowKey.isNull();
    }

    public String getSowKeys() {
        return this._SowKeys.getValue(this.decoder);
    }

    public Field getSowKeysRaw() {
        return this._SowKeys;
    }

    public Message setSowKeys(String v) {
        this._SowKeys.setValue(v, this.encoder);
        return this;
    }

    public Message setSowKeys(byte[] buffer, int offset, int length) {
        this._SowKeys.setValue(buffer, offset, length);
        return this;
    }

    public boolean isSowKeysNull() {
        return this._SowKeys.isNull();
    }

    public int getStatus() {
        return this._Status.getValue();
    }

    public Message setStatus(int v) {
        this._Status.setValue(v);
        return this;
    }

    public String getSubId() {
        return this._SubId.getValue(this.decoder);
    }

    public Field getSubIdRaw() {
        return this._SubId;
    }

    public boolean getSubId(CommandId v) {
        return this._SubId.getValue(v);
    }

    public Message setSubId(String v) {
        this._SubId.setValue(v, this.encoder);
        return this;
    }

    public Message setSubId(CommandId v) {
        this._SubId.setValue(v);
        return this;
    }

    public Message setSubId(byte[] buffer, int offset, int length) {
        this._SubId.setValue(buffer, offset, length);
        return this;
    }

    public boolean isSubIdNull() {
        return this._SubId.isNull();
    }

    public String getSubIds() {
        return this._SubIds.getValue(this.decoder);
    }

    public Field getSubIdsRaw() {
        return this._SubIds;
    }

    public Message setSubIds(String v) {
        this._SubIds.setValue(v, this.encoder);
        return this;
    }

    public Message setSubIds(byte[] buffer, int offset, int length) {
        this._SubIds.setValue(buffer, offset, length);
        return this;
    }

    public boolean isSubIdsNull() {
        return this._SubIds.isNull();
    }

    public String getTimestamp() {
        return this._Timestamp.getValue(this.decoder);
    }

    public Field getTimestampRaw() {
        return this._Timestamp;
    }

    public Message setTimestamp(String v) {
        this._Timestamp.setValue(v, this.encoder);
        return this;
    }

    public Message setTimestamp(byte[] buffer, int offset, int length) {
        this._Timestamp.setValue(buffer, offset, length);
        return this;
    }

    public boolean isTimestampNull() {
        return this._Timestamp.isNull();
    }

    public long getTopN() {
        return this._TopN.getValue();
    }

    public Message setTopN(long v) {
        this._TopN.setValue(v);
        return this;
    }

    public boolean isTopNNull() {
        return this._TopN.isNull();
    }

    public String getTopic() {
        return this._Topic.getValue(this.decoder);
    }

    public Field getTopicRaw() {
        return this._Topic;
    }

    public Message setTopic(String v) {
        this._Topic.setValue(v, this.encoder);
        return this;
    }

    public Message setTopic(byte[] buffer, int offset, int length) {
        this._Topic.setValue(buffer, offset, length);
        return this;
    }

    public boolean isTopicNull() {
        return this._Topic.isNull();
    }

    public long getTopicMatches() {
        return this._TopicMatches.getValue();
    }

    public boolean isTopicMatchesNull() {
        return this._TopicMatches.isNull();
    }

    public Message setTopicMatches(long v) {
        this._TopicMatches.setValue(v);
        return this;
    }

    public String getUserId() {
        return this._UserId.getValue(this.decoder);
    }

    public boolean isUserIdNull() {
        return this._UserId.isNull();
    }

    public Field getUserIdRaw() {
        return this._UserId;
    }

    public Message setUserId(String v) {
        this._UserId.setValue(v, this.encoder);
        return this;
    }

    public Message setUserId(byte[] buffer, int offset, int length) {
        this._UserId.setValue(buffer, offset, length);
        return this;
    }

    public String getVersion() {
        return this._Version.getValue(this.decoder);
    }

    public Field getVersionRaw() {
        return this._Version;
    }

    public boolean isVersionNull() {
        return this._Version.isNull();
    }

    public int getVersionAsInt() {
        int version;
        if (this._Version.isNull()) {
            return 0;
        }
        try {
            version = Client.getVersionAsInt(this._Version.getValue(this.decoder));
        }
        catch (CommandException e) {
            version = 0;
        }
        if (version == 0) {
            version = 99999999;
        }
        return version;
    }

    public Message setVersion(String v) {
        this._Version.setValue(v, this.encoder);
        return this;
    }

    public Message setVersion(byte[] buffer, int offset, int length) {
        this._Version.setValue(buffer, offset, length);
        return this;
    }

    public Message setCorrelationId(String v) {
        this._CorrelationId.setValue(v, this.encoder);
        return this;
    }

    public String getCorrelationId() {
        return this._CorrelationId.getValue(this.decoder);
    }

    public StringField getCorrelationIdRaw() {
        return this._CorrelationId;
    }

    public boolean isCorrelationIdNull() {
        return this._CorrelationId.isNull();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(1024);
        s.append("Message{");
        s.append("Command=").append(CommandField.encodeCommand(this.getCommand())).append("; ");
        if (!this._AckType.isNull()) {
            s.append("AckType=").append(this._AckType).append("; ");
        }
        if (!this._BatchSize.isNull()) {
            s.append("BatchSize=").append(this.getBatchSize()).append("; ");
        }
        if (!this._Bookmark.isNull()) {
            s.append("Bookmark=").append(this.getBookmark()).append("; ");
        }
        if (!this._ClientName.isNull()) {
            s.append("ClientName=").append(this.getClientName()).append("; ");
        }
        if (!this._CommandId.isNull()) {
            s.append("CommandId=").append(this.getCommandId()).append("; ");
        }
        if (!this._Expiration.isNull()) {
            s.append("Expiration=").append(this.getExpiration()).append("; ");
        }
        if (!this._Filter.isNull()) {
            s.append("Filter=").append(this.getFilter()).append("; ");
        }
        if (!this._LeasePeriod.isNull()) {
            s.append("LeasePeriod=").append(this.getLeasePeriod()).append("; ");
        }
        if (!this._OrderBy.isNull()) {
            s.append("OrderBy=").append(this.getOrderBy()).append("; ");
        }
        if (!this._GroupSeqNo.isNull()) {
            s.append("GroupSeqNo=").append(this.getGroupSeqNo()).append("; ");
        }
        if (!this._Matches.isNull()) {
            s.append("Matches=").append(this.getMatches()).append("; ");
        }
        if (!this._MessageType.isNull()) {
            s.append("MessageType=").append(this.getMessageType()).append("; ");
        }
        if (!this._Length.isNull()) {
            s.append("Length=").append(this.getLength()).append("; ");
        }
        if (!this._Options.isNull()) {
            s.append("Options=").append(this.getOptions()).append("; ");
        }
        if (!this._Password.isNull()) {
            s.append("Password=").append(this.getPassword()).append("; ");
        }
        if (!this._QueryId.isNull()) {
            s.append("QueryId=").append(this.getQueryId()).append("; ");
        }
        if (!this._Reason.isNull()) {
            s.append("Reason=").append(ReasonField.encodeReason(this.getReason())).append("; ");
        }
        if (!this._RecordsUpdated.isNull()) {
            s.append("RecordsUpdated=").append(this.getRecordsUpdated()).append("; ");
        }
        if (!this._RecordsInserted.isNull()) {
            s.append("RecordsInserted=").append(this.getRecordsInserted()).append("; ");
        }
        if (!this._RecordsReturned.isNull()) {
            s.append("RecordsReturned=").append(this.getRecordsReturned()).append("; ");
        }
        if (!this._RecordsDeleted.isNull()) {
            s.append("RecordsDeleted=").append(this.getRecordsDeleted()).append("; ");
        }
        if (!this._Sequence.isNull()) {
            s.append("Sequence=").append(this.getSequence()).append("; ");
        }
        if (!this._SowKey.isNull()) {
            s.append("SowKey=").append(this.getSowKey()).append("; ");
        }
        if (!this._SowKeys.isNull()) {
            s.append("SowKeys=").append(this.getSowKeys()).append("; ");
        }
        if (!this._Status.isNull()) {
            s.append("Status=").append(StatusField.encodeStatus(this.getStatus())).append("; ");
        }
        if (!this._SubId.isNull()) {
            s.append("SubId=").append(this.getSubId()).append("; ");
        }
        if (!this._SubIds.isNull()) {
            s.append("SubIds=").append(this.getSubIds()).append("; ");
        }
        if (!this._Timestamp.isNull()) {
            s.append("Timestamp=").append(this.getTimestamp()).append("; ");
        }
        if (!this._TopN.isNull()) {
            s.append("TopN=").append(this.getTopN()).append("; ");
        }
        if (!this._Topic.isNull()) {
            s.append("Topic=").append(this.getTopic()).append("; ");
        }
        if (!this._TopicMatches.isNull()) {
            s.append("TopicMatches=").append(this.getTopicMatches()).append("; ");
        }
        if (!this._CorrelationId.isNull()) {
            s.append("CorrelationId=").append(this.getCorrelationId()).append("; ");
        }
        if (!this._UserId.isNull()) {
            s.append("UserId=").append(this.getUserId()).append("; ");
        }
        if (!this._Data.isNull()) {
            s.append("Data=").append(this.getData()).append("; ");
        }
        s.append('}');
        return s.toString();
    }

    public abstract Message copy();

    public Client getClient() {
        return this._client;
    }

    public void ack() throws AMPSException {
        if (this._client != null && (!this._client.getAutoAck() || this._ignoreAutoAck)) {
            this._client._ack(this._Topic.buffer, this._Topic.position, this._Topic.length, this._Bookmark.buffer, this._Bookmark.position, this._Bookmark.length, null, 0, 0);
        }
    }

    public void ack(byte[] options, int optionsPos, int optionsLen) throws AMPSException {
        if (this._client != null && (!this._client.getAutoAck() || this._ignoreAutoAck)) {
            this._client._ack(this._Topic.buffer, this._Topic.position, this._Topic.length, this._Bookmark.buffer, this._Bookmark.position, this._Bookmark.length, options, optionsPos, optionsLen);
        }
    }

    public void ack(Field options) throws AMPSException {
        if (this._client != null && (!this._client.getAutoAck() || this._ignoreAutoAck)) {
            this._client._ack(this._Topic, this._Bookmark, options);
        }
    }

    public void ack(String options) throws AMPSException {
        if (this._client != null && (!this._client.getAutoAck() || this._ignoreAutoAck)) {
            this._client._ack(this._Topic, this._Bookmark, new Field(options));
        }
    }

    public boolean isIgnoreAutoAck() {
        return this._ignoreAutoAck;
    }

    public void setIgnoreAutoAck() {
        this._ignoreAutoAck = true;
    }

    protected void _copyTo(Message destination) {
        destination._ignoreAutoAck = this._ignoreAutoAck;
        destination._rawBufferLength = this._rawBufferLength;
        destination._rawBufferOffset = 0;
        if (this.buffer != null) {
            destination.buffer = new byte[this._rawBufferLength];
            System.arraycopy(this.buffer, this._rawBufferOffset, destination.buffer, 0, this._rawBufferLength);
        }
        for (int i = 0; i < this._fields.length; ++i) {
            if (this.buffer != null && this._fields[i].buffer == this.buffer) {
                Field f = this._fields[i];
                destination._fields[i].set(destination.buffer, f.position - this._rawBufferOffset, f.length);
                continue;
            }
            destination._fields[i].copyFrom(this._fields[i]);
        }
        destination._bookmarkSeqNo = this._bookmarkSeqNo;
        destination._subscription = this._subscription;
        destination._client = this._client;
    }

    public static final class AckType {
        public static final int None = 0;
        public static final int Received = 1;
        public static final int Parsed = 2;
        public static final int Processed = 4;
        public static final int Persisted = 8;
        public static final int Completed = 16;
        public static final int Stats = 32;
    }

    public static enum SerializationResult {
        OK,
        BufferTooSmall;

    }

    public static final class Options {
        public static final String None = null;
        public static final String Live = "live,";
        public static final String OOF = "oof,";
        public static final String Replace = "replace,";
        public static final String NoEmpties = "no_empties,";
        public static final String SendKeys = "send_keys,";
        public static final String Timestamp = "timestamp,";
        public static final String NoSowKey = "no_sowkey,";
        public static final String Cancel = "cancel,";
        public static final String Expire = "expire,";
        public static final String Resume = "resume,";
        public static final String Pause = "pause,";
        public static final String FullyDurable = "fully_durable,";

        public static String Conflation(String conflation) {
            return String.format("conflation=%s,", conflation);
        }

        public static String ConflationKey(String conflationKey) {
            return String.format("conflation_key=%s,", conflationKey);
        }

        public static String TopN(int topN) {
            return String.format("top_n=%d,", topN);
        }

        public static String SkipN(int skipN) {
            return String.format("skip_n=%d,", skipN);
        }

        public static String MaxBacklog(int maxBacklog) {
            return String.format("max_backlog=%d,", maxBacklog);
        }

        public static String Rate(String rate) {
            return String.format("rate=%s,", rate);
        }

        public static String RateMaxGap(String rateMaxGap) {
            return String.format("rate_max_gap=%s,", rateMaxGap);
        }

        public static String Select(String selectList) {
            return String.format("select=[%s],", selectList);
        }

        public static String Select(Iterable<String> selectList) {
            StringBuilder builder = new StringBuilder();
            builder.append("select=[");
            for (String s : selectList) {
                builder.append(s);
                builder.append(',');
            }
            builder.setCharAt(builder.length() - 1, ']');
            builder.append(',');
            return builder.toString();
        }

        public static String Projection(String projection) {
            return String.format("projection=[%s],", projection);
        }

        public static String Projection(Iterable<String> projection) {
            StringBuilder builder = new StringBuilder();
            builder.append("projection=[");
            for (String s : projection) {
                builder.append(s);
                builder.append(',');
            }
            builder.setCharAt(builder.length() - 1, ']');
            builder.append(',');
            return builder.toString();
        }

        public static String Grouping(String grouping) {
            return String.format("grouping=[%s],", grouping);
        }

        public static String Grouping(Iterable<String> grouping) {
            StringBuilder builder = new StringBuilder();
            builder.append("grouping=[");
            for (String s : grouping) {
                builder.append(s);
                builder.append(',');
            }
            builder.setCharAt(builder.length() - 1, ']');
            builder.append(',');
            return builder.toString();
        }

        public static String AckConflationInterval(String interval) {
            return String.format("ack_conflation=%s,", interval);
        }
    }

    public static final class Reason {
        public static final int None = 0;
        public static final int Duplicate = 1;
        public static final int BadFilter = 2;
        public static final int BadRegexTopic = 3;
        public static final int SubscriptionAlreadyExists = 4;
        public static final int Deleted = 5;
        public static final int Expired = 6;
        public static final int Match = 7;
        public static final int InvalidTopic = 8;
        public static final int NameInUse = 9;
        public static final int AuthFailure = 10;
        public static final int NotEntitled = 11;
        public static final int AuthDisabled = 12;
        public static final int InvalidBookmark = 13;
        public static final int InvalidOrderBy = 14;
        public static final int SubidInUse = 15;
        public static final int NoTopic = 16;
        public static final int LogonFailed = 17;
        public static final int LogonRequired = 18;
        public static final int InvalidTopicOrFilter = 19;
        public static final int InvalidSubId = 20;
        public static final int NoTopicOrFilter = 21;
        public static final int NoClientName = 22;
        public static final int BadSowKey = 23;
        public static final int RegexTopicNotSupported = 24;
        public static final int SowStoreFailed = 25;
        public static final int ParseError = 26;
        public static final int NotSupported = 27;
        public static final int TxStoreFailure = 28;
        public static final int DuplicateLogon = 29;
        public static final int TxnReplayFailed = 30;
        public static final int SowCanceled = 31;
        public static final int InvalidOptions = 32;
        public static final int InvalidMessageType = 33;
        public static final int OrderByTooLarge = 34;
        public static final int RejectedByTransportFilter = 35;
        public static final int SowDeleteInvalid = 36;
        public static final int PublishFilterNoMatch = 37;
        public static final int Other = 38;
    }

    public static final class Status {
        public static final int None = 0;
        public static final int Success = 1;
        public static final int Failure = 2;
        public static final int Retry = 3;
    }

    public static final class Command {
        public static final int Unknown = 0;
        public static final int Publish = 1;
        public static final int Subscribe = 2;
        public static final int Unsubscribe = 4;
        public static final int SOW = 8;
        public static final int Heartbeat = 16;
        public static final int SOWDelete = 32;
        public static final int DeltaPublish = 64;
        public static final int Logon = 128;
        public static final int SOWAndSubscribe = 256;
        public static final int DeltaSubscribe = 512;
        public static final int SOWAndDeltaSubscribe = 1024;
        public static final int StartTimer = 2048;
        public static final int StopTimer = 4096;
        public static final int GroupBegin = 8192;
        public static final int GroupEnd = 16384;
        public static final int OOF = 32768;
        public static final int Ack = 65536;
        public static final int Flush = 131072;
        public static final int NoDataCommands = 137461;
    }
}

