/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.exception.CommandException;
import java.nio.charset.StandardCharsets;

public class NVFIXBuilder {
    private static final int MIN_CAPACITY = 8;
    private byte[] _buffer = null;
    private int _size = 0;
    private int _capacity = 1024;
    private final byte _fieldSeparator;

    public NVFIXBuilder(int capacity, byte fieldSeparator) {
        this._fieldSeparator = fieldSeparator;
        this._capacity = capacity < 8 ? 8 : capacity;
        this._buffer = new byte[this._capacity];
    }

    public void clear() {
        this._size = 0;
    }

    public int getSize() {
        return this._size;
    }

    public byte[] getBytes() {
        return this._buffer;
    }

    private void checkCapacity(int bytesNeeded) {
        if (this._capacity - this._size < bytesNeeded) {
            while (this._capacity - this._size < bytesNeeded) {
                this._capacity *= 2;
            }
            byte[] newbuf = new byte[this._capacity];
            System.arraycopy(this._buffer, 0, newbuf, 0, this._size);
            this._buffer = newbuf;
        }
    }

    public NVFIXBuilder append(String tag, byte[] value, int offset, int length) throws CommandException {
        return this.append(NVFIXBuilder.toBytes(tag), value, offset, length);
    }

    public NVFIXBuilder append(String tag, String value) throws CommandException {
        return this.append(NVFIXBuilder.toBytes(tag), NVFIXBuilder.toBytes(value));
    }

    private NVFIXBuilder append(byte[] tag, byte[] val) {
        return this.append(tag, val, 0, val.length);
    }

    private NVFIXBuilder append(byte[] tag, byte[] val, int valOffset, int valLength) {
        int sizeNeeded = tag.length + 1 + valLength + 1;
        this.checkCapacity(sizeNeeded);
        int writeIndex = this._size;
        System.arraycopy(tag, 0, this._buffer, writeIndex, tag.length);
        this._buffer[writeIndex += tag.length] = 61;
        System.arraycopy(val, valOffset, this._buffer, ++writeIndex, valLength);
        this._buffer[writeIndex += valLength] = this._fieldSeparator;
        this._size += sizeNeeded;
        return this;
    }

    private static byte[] toBytes(String datum) {
        return datum.getBytes(StandardCharsets.ISO_8859_1);
    }
}

