/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.Command;
import com.crankuptheamps.client.FixedRecoveryPoint;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageStream;
import com.crankuptheamps.client.RecoveryPoint;
import com.crankuptheamps.client.RecoveryPointAdapter;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import java.beans.ExceptionListener;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SOWRecoveryPointAdapter
implements RecoveryPointAdapter {
    protected String _trackedName;
    protected String _topic;
    protected String _clientNameField;
    protected String _subIdField;
    protected String _bookmarkField;
    protected Client _client = null;
    protected ExceptionListener _exceptionListener = null;
    protected Field _serializeField = new Field();
    protected long _timeoutMillis = 0L;
    protected boolean _closeClient = false;
    protected boolean _useTimestamp = false;
    protected boolean _throwNotListen = false;
    protected Command _cmd = new Command(1);
    protected MessageStream _stream = null;
    protected boolean _recovering = true;
    protected static final int JSON_START = 11;
    protected static final int JSON_END = 8;
    protected static final int JSON_LEN = 19;
    protected static final int SUBID_LEN = 64;
    protected static final int JSON_INIT_LEN = 256;
    protected String _initStr = null;
    protected int _serializeStart = 0;
    protected RecoveryPoint _current = new FixedRecoveryPoint();
    protected Field EPOCH_FIELD = new Field("0");
    protected Pattern _bookmarkPattern;
    protected Pattern _subIdPattern;
    protected final ConcurrentHashMap<Field, BookmarkField> _lastValue = new ConcurrentHashMap();

    public SOWRecoveryPointAdapter(Client client, String trackedClientName, boolean closeClient, boolean useTimestamp, boolean throwExceptions) {
        this(client, trackedClientName, closeClient, useTimestamp, throwExceptions, 0L, "/ADMIN/bookmark_store", "clientName", "subId", "bookmark");
    }

    public SOWRecoveryPointAdapter(Client client, String trackedClientName, boolean closeClient, boolean useTimestamp, boolean throwExceptions, long timeoutMillis, String topic, String clientNameField, String subIdField, String bookmarkField) {
        this._client = client;
        this._trackedName = trackedClientName;
        this._timeoutMillis = timeoutMillis;
        this._closeClient = closeClient;
        this._useTimestamp = useTimestamp;
        this._throwNotListen = throwExceptions;
        this._topic = topic;
        this._clientNameField = clientNameField;
        this._subIdField = subIdField;
        this._bookmarkField = bookmarkField;
        this._cmd.setTopic(this._topic);
        this._subIdPattern = Pattern.compile("\"" + this._subIdField + "\" *: *\"([^\"]+)\"");
        this._bookmarkPattern = Pattern.compile("\"bookmark\" *: *\"([^\"]*)\"");
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this._exceptionListener = exceptionListener;
    }

    @Override
    public void update(RecoveryPoint recoveryPoint) throws Exception {
        block7: {
            try {
                Field subId = recoveryPoint.getSubId();
                BookmarkField currValue = recoveryPoint.getBookmark();
                BookmarkField prevValue = this._lastValue.get(subId);
                if (prevValue == null || !currValue.equals(prevValue)) {
                    if (!this.serialize(recoveryPoint)) {
                        return;
                    }
                    this._cmd.setData(this._serializeField.buffer, this._serializeField.position, this._serializeField.length);
                    this._client.execute(this._cmd);
                    if (prevValue == null) {
                        this._lastValue.put(subId.copy(), currValue.copy());
                    } else {
                        this._lastValue.put(subId, currValue.copy());
                    }
                }
            }
            catch (Exception e) {
                if (this._throwNotListen) {
                    throw new StoreException("Sow update exception " + e, e);
                }
                if (this._exceptionListener == null) break block7;
                this._exceptionListener.exceptionThrown(new StoreException("Sow update exception " + e.toString(), e));
            }
        }
    }

    @Override
    public void purge() throws StoreException {
        try {
            String filter = String.format("/%s = '%s'", this._clientNameField, this._trackedName);
            this._client.sowDelete(this._topic, filter, this._timeoutMillis);
        }
        catch (AMPSException e) {
            throw new StoreException("Error purging recovery state from SOW: " + e, e);
        }
    }

    @Override
    public void purge(Field subId) throws StoreException {
        try {
            String filter = String.format("/%s = '%s' AND /%s = '%s'", this._clientNameField, this._trackedName, this._subIdField, subId);
            this._client.sowDelete(this._topic, filter, this._timeoutMillis);
        }
        catch (Exception e) {
            throw new StoreException("Error purging recovery state from SOW for subId " + subId + ": " + e, e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this._client != null) {
            try {
                this._client.publishFlush(this._timeoutMillis);
            }
            catch (DisconnectedException disconnectedException) {
            }
            catch (Exception e) {
                if (this._throwNotListen) {
                    throw new StoreException("SOWRecoveryPointAdapter error flushing to store during close", e);
                }
                if (this._exceptionListener != null) {
                    this._exceptionListener.exceptionThrown(new StoreException("SOWRecoveryPointAdapter error flushing to store during close", e));
                }
            }
            finally {
                if (this._closeClient) {
                    this._client.close();
                }
            }
        }
    }

    protected void runQuery() {
        block4: {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append('/').append(this._clientNameField).append("=\"").append(this._trackedName).append('\"');
                Command cmd = new Command("sow");
                cmd.setTopic(this._topic).setTimeout(this._timeoutMillis).setFilter(builder.toString());
                builder.setLength(0);
                builder.append("select=[-/,+/").append(this._subIdField).append(",+/").append(this._bookmarkField).append(']');
                if (this._useTimestamp) {
                    builder.append(",timestamp");
                    cmd.setOptions(builder.toString());
                } else {
                    cmd.setOptions(builder.toString());
                }
                this._stream = this._client.execute(cmd);
            }
            catch (Exception e) {
                if (this._throwNotListen || this._exceptionListener == null) break block4;
                this._exceptionListener.exceptionThrown(new StoreException("Failed to execute SOW query for recovery", e));
                this._stream = null;
            }
        }
        this._recovering = false;
    }

    @Override
    public boolean hasNext() {
        if (this._recovering && this._stream == null) {
            this.runQuery();
        }
        return this._stream != null && this._stream.hasNext();
    }

    @Override
    public RecoveryPoint next() {
        Message m;
        if (this._recovering && this._stream == null) {
            this.runQuery();
        }
        if ((m = this._stream.next()) == null) {
            this._stream = null;
            return null;
        }
        int command = m.getCommand();
        if (command == 8192) {
            return this.next();
        }
        if (command != 8) {
            this._stream = null;
            return null;
        }
        try {
            if (!this.deserialize(m)) {
                return this.next();
            }
        }
        catch (Exception e) {
            return null;
        }
        return this._current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<RecoveryPoint> iterator() {
        return this;
    }

    protected boolean serialize(RecoveryPoint recoveryPoint) throws Exception {
        BookmarkField bookmark = recoveryPoint.getBookmark();
        if (bookmark.equals(this.EPOCH_FIELD)) {
            return false;
        }
        Field subId = recoveryPoint.getSubId();
        int endLength = subId.length + this._bookmarkField.length() + bookmark.length + 8;
        int length = this._clientNameField.length() + this._trackedName.length() + this._subIdField.length() + 11 + endLength;
        if (this._serializeField.buffer == null || this._serializeField.buffer.length < length) {
            int newLength = length + (128 - length % 128);
            byte[] buffer = new byte[newLength];
            this._serializeField.set(buffer, 0, length);
            this.initSerialization();
        }
        System.arraycopy(subId.buffer, subId.position, this._serializeField.buffer, this._serializeStart, subId.length);
        int pos = this._serializeStart + subId.length;
        this._serializeField.buffer[pos++] = 34;
        this._serializeField.buffer[pos++] = 44;
        this._serializeField.buffer[pos++] = 34;
        System.arraycopy(this._bookmarkField.getBytes("UTF8"), 0, this._serializeField.buffer, pos, this._bookmarkField.length());
        pos += this._bookmarkField.length();
        this._serializeField.buffer[pos++] = 34;
        this._serializeField.buffer[pos++] = 58;
        this._serializeField.buffer[pos++] = 34;
        System.arraycopy(bookmark.buffer, bookmark.position, this._serializeField.buffer, pos, bookmark.length);
        pos += bookmark.length;
        this._serializeField.buffer[pos++] = 34;
        this._serializeField.buffer[pos] = 125;
        this._serializeField.length = length;
        return true;
    }

    protected boolean deserialize(Message m) throws Exception {
        String timestamp;
        boolean subIdIdx = false;
        boolean bookmarkIdx = false;
        String data = m.getData();
        Matcher subIdMatch = this._subIdPattern.matcher(data);
        if (!subIdMatch.find()) {
            throw new StoreException("SubId NOT FOUND in SOW record during recovery: data = " + data);
        }
        Matcher bookmarkMatch = this._bookmarkPattern.matcher(data);
        if (!bookmarkMatch.find()) {
            throw new StoreException("Recovery bookmark NOT FOUND in SOW record during recovery: data = " + data);
        }
        String subId = subIdMatch.group(1);
        String bookmark = bookmarkMatch.group(1);
        if (this._useTimestamp && (timestamp = m.getTimestamp()) != null && !timestamp.isEmpty() && bookmark.charAt(0) != '[' && bookmark.charAt(0) != '(') {
            bookmark = bookmark + "," + timestamp;
        }
        int subIdLen = subId.length();
        int bookmarkLen = bookmark.length();
        int len = subIdLen + bookmarkLen;
        if (this._serializeField.buffer == null || this._serializeField.buffer.length < len) {
            byte[] buffer = new byte[len];
            this._serializeField.set(buffer, 0, len);
        }
        System.arraycopy(subId.getBytes("UTF8"), 0, this._serializeField.buffer, 0, subIdLen);
        System.arraycopy(bookmark.getBytes("UTF8"), 0, this._serializeField.buffer, subIdLen, bookmarkLen);
        this._current.getSubId().set(this._serializeField.buffer, 0, subIdLen);
        this._current.getBookmark().set(this._serializeField.buffer, subIdLen, bookmarkLen);
        return true;
    }

    protected void initSerialization() throws Exception {
        if (this._serializeField.buffer == null || this._serializeField.buffer.length < 256) {
            byte[] buffer = new byte[256];
            this._serializeField.set(buffer, 0, 256);
        }
        if (this._initStr == null) {
            StringBuilder builder = new StringBuilder(256);
            builder.append("{\"").append(this._clientNameField).append("\":\"").append(this._trackedName).append("\",\"").append(this._subIdField).append("\":\"");
            this._initStr = builder.toString();
            this._serializeStart = this._initStr.length();
        }
        System.arraycopy(this._initStr.getBytes("UTF8"), 0, this._serializeField.buffer, 0, this._initStr.length());
    }
}

