/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BlockPublishStore;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import java.io.IOException;
import java.util.Arrays;

public class ArrayStoreBuffer
implements BlockPublishStore.Buffer {
    volatile byte[] _buf = null;
    volatile int _pos = 0;
    PublishStoreResizeHandler _resizeHandler = null;
    Store _store = null;

    public byte[] getBuffer() {
        return this._buf;
    }

    public long getSize() throws IOException {
        return this._buf == null ? 0L : (long)this._buf.length;
    }

    public void setSize(long newSize) throws IOException {
        if (this._resizeHandler != null && !this._resizeHandler.invoke(this._store, newSize)) {
            return;
        }
        byte[] oldBuf = this._buf;
        if (oldBuf == null || newSize > (long)oldBuf.length) {
            byte[] newBuf = new byte[(int)newSize];
            if (oldBuf != null && oldBuf.length > 0) {
                System.arraycopy(oldBuf, 0, newBuf, 0, oldBuf.length);
            }
            this._buf = newBuf;
        }
    }

    public long getPosition() throws IOException {
        return this._pos;
    }

    public void setPosition(long position) throws IOException {
        this._pos = (int)position;
    }

    public void putByte(byte b) throws IOException {
        this._buf[this._pos++] = b;
    }

    public byte getByte() throws IOException {
        return this._buf[this._pos++];
    }

    public void putInt(int i) throws IOException {
        this._buf[this._pos++] = (byte)((i & 0xFF000000) >> 24);
        this._buf[this._pos++] = (byte)((i & 0xFF0000) >> 16);
        this._buf[this._pos++] = (byte)((i & 0xFF00) >> 8);
        this._buf[this._pos++] = (byte)(i & 0xFF);
    }

    public int getInt() throws IOException {
        int result = this._buf[this._pos + 3] & 0xFF | (this._buf[this._pos + 2] & 0xFF) << 8 | (this._buf[this._pos + 1] & 0xFF) << 16 | (this._buf[this._pos + 0] & 0xFF) << 24;
        this._pos += 4;
        return result;
    }

    public void putLong(long l) throws IOException {
        this._buf[this._pos++] = (byte)((l & 0xFF00000000000000L) >> 56);
        this._buf[this._pos++] = (byte)((l & 0xFF000000000000L) >> 48);
        this._buf[this._pos++] = (byte)((l & 0xFF0000000000L) >> 40);
        this._buf[this._pos++] = (byte)((l & 0xFF00000000L) >> 32);
        this._buf[this._pos++] = (byte)((l & 0xFF000000L) >> 24);
        this._buf[this._pos++] = (byte)((l & 0xFF0000L) >> 16);
        this._buf[this._pos++] = (byte)((l & 0xFF00L) >> 8);
        this._buf[this._pos++] = (byte)(l & 0xFFL);
    }

    public long getLong() throws IOException {
        long result = this._buf[this._pos + 7] & 0xFF | (this._buf[this._pos + 6] & 0xFF) << 8 | (this._buf[this._pos + 5] & 0xFF) << 16 | (this._buf[this._pos + 4] & 0xFF) << 24 | (this._buf[this._pos + 3] & 0xFF) << 32 | (this._buf[this._pos + 2] & 0xFF) << 40 | (this._buf[this._pos + 1] & 0xFF) << 48 | (this._buf[this._pos + 0] & 0xFF) << 56;
        this._pos += 8;
        return result;
    }

    public void putBytes(BlockPublishStore.ByteSequence bytes) throws IOException {
        System.arraycopy(bytes.array, (int)bytes.offset, this._buf, this._pos, (int)bytes.len);
        this._pos = (int)((long)this._pos + bytes.len);
    }

    public void getBytes(BlockPublishStore.ByteSequence outBytes) throws IOException {
        outBytes.array = this._buf;
        outBytes.offset = this._pos;
        this._pos = (int)((long)this._pos + outBytes.len);
    }

    public void zero(long offset, int length) throws IOException {
        Arrays.fill(this._buf, (int)offset, (int)offset + length, (byte)0);
    }

    public void setResizeHandler(PublishStoreResizeHandler handler, Store store) {
        this._resizeHandler = handler;
        this._store = store;
    }
}

