/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.ClientDisconnectHandler2;
import com.crankuptheamps.client.Command;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.ConnectionInfo;
import com.crankuptheamps.client.ConnectionStateListener;
import com.crankuptheamps.client.DefaultAuthenticator;
import com.crankuptheamps.client.DefaultBookmarkStore;
import com.crankuptheamps.client.DefaultDisconnectHandler;
import com.crankuptheamps.client.DefaultMessageHandler;
import com.crankuptheamps.client.DefaultSubscriptionManager;
import com.crankuptheamps.client.FIXProtocol;
import com.crankuptheamps.client.FailedWriteHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.MessageRouter;
import com.crankuptheamps.client.MessageStream;
import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.ProtocolFactory;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.SubscriptionManager;
import com.crankuptheamps.client.Transport;
import com.crankuptheamps.client.TransportDisconnectHandler;
import com.crankuptheamps.client.TransportFactory;
import com.crankuptheamps.client.TransportFilter;
import com.crankuptheamps.client.URIProperties;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.AuthenticationException;
import com.crankuptheamps.client.exception.BadFilterException;
import com.crankuptheamps.client.exception.BadRegexTopicException;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.client.exception.ConnectionRefusedException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.InvalidTopicException;
import com.crankuptheamps.client.exception.InvalidURIException;
import com.crankuptheamps.client.exception.NameInUseException;
import com.crankuptheamps.client.exception.NotEntitledException;
import com.crankuptheamps.client.exception.RetryOperationException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.exception.SubidInUseException;
import com.crankuptheamps.client.exception.SubscriptionAlreadyExistsException;
import com.crankuptheamps.client.exception.TimedOutException;
import com.crankuptheamps.client.exception.UnknownException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.LongField;
import com.crankuptheamps.client.fields.StringField;
import java.beans.ExceptionListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Client
implements Closeable {
    private volatile String name = null;
    private Transport transport = null;
    private long haSequenceNumber = 1L;
    private Store publishStore = null;
    private volatile URI uri = null;
    private volatile ClientDisconnectHandler disconnectHandler = new DefaultDisconnectHandler();
    protected ExceptionListener exceptionListener = null;
    private Message message = null;
    private Command command = new Command();
    private Message beatMessage = null;
    private final Lock lock = new ReentrantLock();
    private final Condition ackReceived = this.lock.newCondition();
    private final HashSet<ConnectionStateListener> _connectionStateListeners = new HashSet();
    private Map<CommandId, AckResponse> _acks = new ConcurrentHashMap<CommandId, AckResponse>();
    private MessageRouter _routes = new MessageRouter();
    private ClientHandler _handler = new ClientHandler(this);
    private MessageHandler lastChanceMessageHandler = new DefaultMessageHandler();
    private MessageHandler duplicateMessageHandler = new DefaultMessageHandler();
    private int version = 196608;
    private String _version = null;
    private volatile BookmarkStore bookmarkStore = new DefaultBookmarkStore();
    private volatile String username;
    private volatile SubscriptionManager subscriptionManager = new DefaultSubscriptionManager();
    private volatile boolean _badTimeToHAPublish = false;
    private volatile FailedWriteHandler _failedWriteHandler = null;
    private int serverVersion = 0;
    private StopWatch heartbeatTimer = new StopWatch();
    public static final int MIN_PERSISTED_BOOKMARK_VERSION = 3080000;
    public static final int MIN_MULTI_BOOKMARK_VERSION = 4000000;
    private static final int MIN_FLUSH_VERSION = 4000000;

    public Client(String name) {
        this(name, null);
    }

    public Client(String name, int version) {
        this(name, null, version);
    }

    public Client(String name, Transport transport) {
        this(name, transport, 196608);
    }

    public Client(String name, Transport transport, int version) {
        this.name = name;
        if (transport != null) {
            this.transport = transport;
            this.transport.setMessageHandler(this._handler);
            this.transport.setDisconnectHandler(this._handler);
            this.message = this.transport.allocateMessage();
            this.beatMessage = this.transport.allocateMessage();
            this.beatMessage.setCommand(16);
            this.beatMessage.setOptions("beat");
        }
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public static int getVersionAsInt(String version) throws CommandException {
        if (version == null || version.length() == 0) {
            return 0;
        }
        int retVersion = 0;
        byte c = 0;
        int dots = 0;
        int lastDot = -1;
        byte[] bytes = version.getBytes();
        for (int i = 0; i < version.length() && dots < 4; ++i) {
            c = bytes[i];
            if (c == 46) {
                ++dots;
                retVersion *= 10;
                if (i - lastDot > 3) {
                    throw new CommandException("Too many digits between dots found translating version string.");
                }
                if (i - lastDot == 3) {
                    retVersion += bytes[i - 2] - 48;
                }
                retVersion *= 10;
                retVersion += bytes[i - 1] - 48;
                lastDot = i;
                continue;
            }
            if (c < 48 || c > 57) {
                throw new CommandException("Invalid character found in version string.");
            }
            if (i != version.length() - 1) continue;
            ++dots;
            retVersion *= 10;
            if (i - lastDot > 2) {
                throw new CommandException("Too many digits between dots found translating version string.");
            }
            if (i - lastDot == 2) {
                retVersion += bytes[i - 1] - 48;
            }
            retVersion *= 10;
            retVersion += bytes[i] - 48;
        }
        while (dots < 4) {
            retVersion *= 100;
            ++dots;
        }
        return retVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport getTransport() {
        try {
            this.lock.lock();
            Transport transport = this.transport;
            return transport;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBookmarkStore(BookmarkStore val) {
        this.bookmarkStore = val;
        if (this.bookmarkStore != null) {
            this.bookmarkStore.setServerVersion(this.serverVersion);
        }
    }

    public BookmarkStore getBookmarkStore() {
        return this.bookmarkStore;
    }

    public void setPublishStore(Store store) {
        this.publishStore = store;
    }

    public Store getPublishStore() {
        return this.publishStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String uri) throws ConnectionException {
        this.lock.lock();
        try {
            try {
                this.uri = new URI(uri);
            }
            catch (URISyntaxException urisex) {
                throw new InvalidURIException(urisex);
            }
            if (this.transport == null) {
                URIProperties props = new URIProperties(this.uri);
                String sProtocol = this.uri.getPath().substring(1, this.uri.getPath().length());
                Protocol messageType = ProtocolFactory.createProtocol(sProtocol, props);
                if (this.version == 65536 && messageType instanceof FIXProtocol) {
                    ((FIXProtocol)messageType).setV1(true);
                }
                this.transport = TransportFactory.createTransport(this.uri.getScheme(), messageType, props);
                this.message = this.transport.allocateMessage();
                this.beatMessage = this.transport.allocateMessage();
                this.beatMessage.setCommand(16);
                this.beatMessage.setOptions("beat");
                this.transport.setMessageHandler(this._handler);
                this.transport.setDisconnectHandler(this._handler);
            }
            this.transport.connect(this.uri);
            this.broadcastConnectionStateChanged(1);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDisconnectHandler(ClientDisconnectHandler disconnectHandler_) {
        this.disconnectHandler = disconnectHandler_;
    }

    public ClientDisconnectHandler getDisconnectHandler() {
        return this.disconnectHandler;
    }

    public void setUnhandledMessageHandler(MessageHandler messageHandler) {
        this.setLastChanceMessageHandler(messageHandler);
    }

    public void setLastChanceMessageHandler(MessageHandler messageHandler) {
        this.lastChanceMessageHandler = messageHandler;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    private void absorbedException(Exception e) {
        try {
            if (this.exceptionListener != null) {
                this.exceptionListener.exceptionThrown(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDuplicateMessageHandler(MessageHandler messageHandler) {
        this.duplicateMessageHandler = messageHandler;
    }

    public void setFailedWriteHandler(FailedWriteHandler handler_) {
        this._failedWriteHandler = handler_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionStateListener(ConnectionStateListener listener_) {
        this.lock.lock();
        try {
            this._connectionStateListeners.add(listener_);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionStateListener(ConnectionStateListener listener_) {
        this.lock.lock();
        try {
            this._connectionStateListeners.remove(listener_);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void broadcastConnectionStateChanged(int newState_) {
        this.lock.lock();
        for (ConnectionStateListener listener : this._connectionStateListeners) {
            try {
                listener.connectionStateChanged(newState_);
            }
            catch (Throwable t) {}
        }
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Transport currentTransport = null;
        this.lock.lock();
        currentTransport = this.transport;
        this.heartbeatTimer.setTimeout(0L);
        this.lock.unlock();
        if (currentTransport != null) {
            currentTransport.disconnect();
        }
        this.lock.lock();
        try {
            this._routes.clear();
            this.cancelSynchronousWaiters(Integer.MAX_VALUE);
            this.broadcastConnectionStateChanged(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message allocateMessage() {
        try {
            this.lock.lock();
            Message message = this.transport.allocateMessage();
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws DisconnectedException {
        this.lock.lock();
        try {
            this.sendInternal(message);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendInternal(Message message) throws DisconnectedException {
        assert (((ReentrantLock)this.lock).isHeldByCurrentThread());
        while (true) {
            Transport currentTransport = this.transport;
            int version = currentTransport.getVersion();
            try {
                currentTransport.sendWithoutRetry(message);
                return version;
            }
            catch (DisconnectedException d) {
                this.lock.unlock();
                try {
                    currentTransport.handleCloseEvent(version, "Error occured while sending message", d);
                    continue;
                }
                catch (RetryOperationException r) {
                    if (message.getCommand() != 2) continue;
                    int n = currentTransport.getVersion();
                    return n;
                }
                finally {
                    this.lock.lock();
                    continue;
                }
            }
            break;
        }
    }

    public CommandId send(MessageHandler messageHandler, Message message, long timeout) throws AMPSException {
        CommandId id = null;
        String strId = message.getCommandId();
        if (strId != null) {
            id = new CommandId(strId);
        }
        int requestedAcks = message.getAckType();
        int systemAddedAcks = 0;
        boolean isSubscribe = false;
        switch (message.getCommand()) {
            case 2: 
            case 512: {
                if (this.serverVersion >= 3080000 && message.getBookmark() != null) {
                    systemAddedAcks |= 0xC;
                }
            }
            case 256: 
            case 1024: {
                if (id == null) {
                    id = CommandId.nextIdentifier();
                    message.setCommandId(id);
                }
                if (message.getSubId() == null) {
                    message.setSubId(id);
                }
                message.setSendMatchingIds(true);
                isSubscribe = true;
            }
            case 8: {
                if (id == null) {
                    id = CommandId.nextIdentifier();
                    message.setCommandId(id);
                }
                if (message.getQueryId() == null) {
                    message.setQueryId(id);
                }
                systemAddedAcks |= 8;
                if (!isSubscribe) {
                    systemAddedAcks |= 0x10;
                }
                message.setAckType(requestedAcks |= systemAddedAcks);
                this._routes.addRoute(id, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
                this.lock.lock();
                try {
                    this.syncAckProcessing(id, message, timeout);
                    break;
                }
                catch (TimedOutException e) {
                    this._routes.removeRoute(id);
                    throw e;
                }
                finally {
                    this.lock.unlock();
                }
            }
            case 1: 
            case 4: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 2048: 
            case 4096: {
                if (message.getAckType() != 0) {
                    if (id == null) {
                        id = CommandId.nextIdentifier();
                        message.setCommandId(id);
                    }
                    if (messageHandler != null) {
                        this._routes.addRoute(id, messageHandler, message.getAckType(), 0, false);
                    }
                }
                this.send(message);
                break;
            }
            default: {
                throw new CommandException("Command type can not be sent directly to AMPS");
            }
        }
        return id;
    }

    public MessageStream execute(Command command) throws AMPSException {
        boolean statsAck;
        MessageHandler existingHandler;
        byte[] subId;
        boolean useExistingHandler;
        boolean bl = useExistingHandler = command.getSubId() != null && (command.getOptions() != null && command.getOptions().contains("replace") || command.getCommand() == 8);
        if (useExistingHandler && (subId = command.getSubId().id) != null && (existingHandler = this._routes.findRoute(command.getSubId())) != null) {
            this.executeAsync(command, existingHandler);
            return existingHandler instanceof MessageStream ? (MessageStream)existingHandler : null;
        }
        MessageStream result = new MessageStream(this);
        CommandId cid = this.executeAsync(command, result);
        boolean bl2 = statsAck = (command.getAckType() & 0x20) > 0;
        if (statsAck) {
            result.setStatsOnly();
        } else if (command.getCommand() == 8) {
            result.setSOWOnly();
        } else if (cid != null) {
            result.setSubscription(cid);
        } else {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId executeAsync(Command command, MessageHandler handler) throws AMPSException {
        this.lock.lock();
        try {
            CommandId commandId = this.executeAsyncNoLock(command, handler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    private CommandId executeAsyncNoLock(Command command, MessageHandler messageHandler) throws AMPSException {
        CommandId cid;
        block31: {
            boolean useSyncSend;
            boolean isPublishStore;
            cid = command.prepare(this);
            int systemAddedAcks = 8;
            boolean bl = isPublishStore = this.publishStore != null && command.needsSequenceNumber();
            if (command.getCommand() == 8) {
                systemAddedAcks |= 0x10;
            }
            if (command.getBookmark() != null) {
                if (command.isSubscribe() && this.serverVersion >= 3080000) {
                    systemAddedAcks |= 4;
                    command._message.setAckType(4 | command.getAckType());
                }
                if (command.getBookmark().equals("recent")) {
                    if (this.bookmarkStore != null) {
                        Field mostRecent = this.bookmarkStore.getMostRecent(command._message.getSubIdRaw());
                        command._message.setBookmark(mostRecent.buffer, mostRecent.position, mostRecent.length);
                    } else {
                        command._message.setBookmark("0");
                    }
                }
            }
            if (isPublishStore) {
                systemAddedAcks |= 4;
                command._message.setAckType(4 | command.getAckType());
            }
            if (messageHandler != null) {
                CommandId subid = command.getSubId();
                CommandId qid = command.getQueryId();
                boolean isSubscribe = command.isSubscribe();
                if (qid != null) {
                    this._routes.addRoute(qid, messageHandler, command.getAckType(), systemAddedAcks, isSubscribe);
                }
                if (subid != null) {
                    this._routes.addRoute(subid, messageHandler, command.getAckType(), systemAddedAcks, isSubscribe);
                } else if (cid != null) {
                    this._routes.addRoute(cid, messageHandler, command.getAckType(), systemAddedAcks, isSubscribe);
                } else {
                    throw new IllegalArgumentException("To use a messagehandler, you must also supply a command or subscription ID.");
                }
            }
            boolean bl2 = useSyncSend = cid != null && (command.getAckType() & 8) > 0;
            if (isPublishStore) {
                while (true) {
                    if (!this._badTimeToHAPublish) {
                        long haSeqNumber = this.haSequenceNumber++;
                        command._message.setSequence(haSeqNumber);
                        command.setClientSequenceNumber(haSeqNumber);
                        byte[] data = null;
                        long dataOffset = 0L;
                        long dataLength = 0L;
                        byte[] corId = command._message._CorrelationId.buffer;
                        long corIdOffset = command._message._CorrelationId.position;
                        long corIdLength = command._message._CorrelationId.length;
                        int expiration = -1;
                        StringField topic = command._message._Topic;
                        if (command._message._Data.length != 0) {
                            data = command._message._Data.buffer;
                            dataOffset = command._message._Data.position;
                            dataLength = command._message._Data.length;
                            if (command.Command != 32) {
                                if (command.hasExpiration()) {
                                    expiration = command.Expiration;
                                    this.publishStore.store(haSeqNumber, command.Command, topic.buffer, topic.position, topic.length, data, dataOffset, dataLength, corId, corIdOffset, corIdLength, expiration);
                                } else {
                                    this.publishStore.store(haSeqNumber, command.Command, topic.buffer, topic.position, topic.length, data, dataOffset, dataLength, corId, corIdOffset, corIdLength);
                                }
                            } else {
                                expiration = 1;
                                this.publishStore.store(haSeqNumber, command.Command, topic.buffer, topic.position, topic.length, data, dataOffset, dataLength, expiration, cid);
                            }
                        } else if (command.Filter != null) {
                            Field filter = command._message.getFilterRaw();
                            dataLength = filter.length;
                            data = filter.buffer;
                            dataOffset = filter.position;
                            expiration = 2;
                            this.publishStore.store(haSeqNumber, command.Command, topic.buffer, topic.position, topic.length, data, dataOffset, dataLength, expiration, cid);
                        } else {
                            Field sowKeys = command._message.getSowKeysRaw();
                            dataLength = sowKeys.length;
                            data = sowKeys.buffer;
                            dataOffset = sowKeys.position;
                            expiration = 4;
                            this.publishStore.store(haSeqNumber, command.Command, topic.buffer, topic.position, topic.length, data, dataOffset, dataLength, expiration, cid);
                        }
                        if (useSyncSend) {
                            this.syncAckProcessing(cid, command._message, command.getTimeout());
                        } else {
                            this.sendInternal(command._message);
                        }
                        break block31;
                    }
                    this.lock.unlock();
                    try {
                        Thread.yield();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.lock.lock();
                }
            }
            if (useSyncSend) {
                this.syncAckProcessing(cid, command._message, command.getTimeout());
            } else {
                this.sendInternal(command._message);
            }
        }
        if (command.isSubscribe()) {
            this.subscriptionManager.subscribe(messageHandler, command.getCommand(), command.getSubId(), command.getTopic(), command.getFilter(), command.getBookmark(), command.getOptions(), command.getBatchSize());
            return command.getSubId();
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeartbeat(int intervalSeconds_, int timeoutSeconds_) throws DisconnectedException {
        if (this.transport != null) {
            this.lock.lock();
            try {
                if (intervalSeconds_ > 0) {
                    this.message.reset();
                    this.message.setCommand(16);
                    this.message.setOptions(String.format("start,%d", intervalSeconds_));
                    this.heartbeatTimer.setTimeout(intervalSeconds_ * 1000);
                    this.heartbeatTimer.start();
                    this.sendInternal(this.message);
                }
                this.transport.setReadTimeout(timeoutSeconds_ * 1000);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void setHeartbeat(int intervalSeconds_) throws DisconnectedException {
        this.setHeartbeat(intervalSeconds_, intervalSeconds_ * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long publish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(1).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
            long l = this.command.getClientSequenceNumber();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long publish(String topic, String data) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(1).setTopic(topic).setData(data);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
            long l = this.command.getClientSequenceNumber();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long publish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength, int expiration) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(1).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength).setExpiration(expiration);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
            long l = this.command.getClientSequenceNumber();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long publish(String topic, String data, int expiration) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(1).setTopic(topic).setData(data).setExpiration(expiration);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
            long l = this.command.getClientSequenceNumber();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deltaPublish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(64).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deltaPublish(String topic, String data) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(64).setTopic(topic).setData(data);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deltaPublish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength, int expiration) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(64).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength).setExpiration(expiration);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deltaPublish(String topic, String data, int expiration) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        this.lock.lock();
        try {
            this.command.reset(64).setTopic(topic).setData(data).setExpiration(expiration);
            if (this.publishStore != null) {
                this.command.setAckType(4);
            }
            this.executeAsyncNoLock(this.command, null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() throws AMPSException {
        this.lock.lock();
        try {
            this.executeAsyncNoLock(this.command.reset(2048), null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId stopTimer(MessageHandler handler_) throws AMPSException {
        CommandId id = null;
        this.lock.lock();
        try {
            id = this.executeAsyncNoLock(this.command.reset(4096).addAckType(32), handler_);
        }
        finally {
            this.lock.unlock();
        }
        return id;
    }

    public CommandId logon(long timeout) throws ConnectionException {
        return this.logon(timeout, new DefaultAuthenticator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId logon(long timeout, Authenticator authenticator) throws ConnectionException {
        if (authenticator == null) {
            authenticator = new DefaultAuthenticator();
        }
        CommandId id = CommandId.nextIdentifier();
        this.lock.lock();
        try {
            this.message.reset();
            this.message.setCommand(128);
            this.message.setCommandId(id);
            this.message.setClientName(this.name);
            if (this.uri.getUserInfo() != null) {
                int upSep = this.uri.getUserInfo().indexOf(58);
                if (upSep < 0) {
                    this.username = this.uri.getUserInfo();
                    this.message.setUserId(this.username);
                    this.message.setPassword(authenticator.authenticate(this.username, null));
                } else {
                    this.username = this.uri.getUserInfo().substring(0, upSep);
                    String passToken = this.uri.getUserInfo().substring(upSep + 1);
                    this.message.setUserId(this.username);
                    this.message.setPassword(authenticator.authenticate(this.username, passToken));
                }
            }
            try {
                if (this.version >= 196608) {
                    this.message.setAckType(8);
                    String version = this.getVersion();
                    if (version != null && version.length() != 0) {
                        this.message.setVersion(version);
                    } else {
                        this.message.setVersion("notinmanifest");
                    }
                    AckResponse response = null;
                    while (true) {
                        response = this.syncAckProcessing(id, this.message, timeout);
                        if (response.state != 3) break;
                        this.message.setPassword(authenticator.retry(response.username, response.password));
                        this.username = response.username;
                    }
                    this.serverVersion = response.serverVersion;
                    if (this.bookmarkStore != null) {
                        this.bookmarkStore.setServerVersion(this.serverVersion);
                    }
                    authenticator.completed(response.username, response.password, response.reason);
                } else {
                    this.sendInternal(this.message);
                }
            }
            catch (CommandException e) {
                this.absorbedException(e);
            }
            if (this.publishStore != null) {
                try {
                    this.publishStore.replay(new ClientStoreReplayer(this));
                }
                catch (StoreException storeException) {
                    throw new ConnectionException("A local store exception occured while logging on.", storeException);
                }
            }
            CommandId commandId = id;
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId logon() throws ConnectionException {
        return this.logon(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId bookmarkSubscribe(MessageHandler messageHandler, String topic, String filter, CommandId subId, String bookmark, String options, long timeout) throws AMPSException {
        if (bookmark == null) {
            throw new AMPSException("A bookmark (or one of the Client.Bookmarks constants) is required to initiate a bookmark subscription.");
        }
        this.lock.lock();
        try {
            this.command.reset(2).setTopic(topic).setFilter(filter).setOptions(options).setBookmark(bookmark);
            if (subId != null) {
                this.command.setSubId(subId);
            }
            this.executeAsyncNoLock(this.command, messageHandler);
            CommandId commandId = this.command.getSubId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId bookmarkDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, CommandId subId, String bookmark, String options, long timeout) throws AMPSException {
        if (bookmark == null) {
            throw new AMPSException("A bookmark (or one of the Client.Bookmarks constants) is required to initiate a bookmark delta subscription.");
        }
        this.lock.lock();
        try {
            this.command.reset(512).setTopic(topic).setFilter(filter).setOptions(options).setBookmark(bookmark);
            if (subId != null) {
                this.command.setSubId(subId);
            }
            this.executeAsyncNoLock(this.command, messageHandler);
            CommandId commandId = this.command.getSubId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId subscribe(MessageHandler messageHandler, String topic, String filter, long timeout) throws AMPSException {
        return this.subscribe(messageHandler, topic, filter, Message.Options.None, timeout);
    }

    public CommandId subscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout) throws AMPSException {
        return this.subscribe(messageHandler, topic, filter, options, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId subscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout, String subId) throws AMPSException {
        this.lock.lock();
        try {
            if (subId == null && options != null && options.contains("replace")) {
                throw new CommandException("Cannot issue a replacement subscription; a valid subscription id is required.");
            }
            this.command.reset(2).setTopic(topic).setFilter(filter).setOptions(options).setTimeout(timeout).setSubId(subId);
            this.executeAsyncNoLock(this.command, messageHandler);
            CommandId commandId = this.command.getSubId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MessageStream subscribe(String topic) throws AMPSException {
        return this.execute(new Command("subscribe").setTopic(topic));
    }

    public MessageStream subscribe(String topic, String filter) throws AMPSException {
        return this.execute(new Command("subscribe").setTopic(topic).setFilter(filter));
    }

    public CommandId subscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.subscribe(messageHandler, topic, null, timeout);
    }

    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout) throws AMPSException {
        return this.deltaSubscribe(messageHandler, topic, filter, options, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout, String subId) throws AMPSException {
        this.lock.lock();
        try {
            this.command.reset(512).setTopic(topic).setFilter(filter).setOptions(options).setTimeout(timeout);
            if (subId != null) {
                this.command.setSubId(new CommandId(subId));
            }
            this.executeAsyncNoLock(this.command, messageHandler);
            CommandId commandId = this.command.getSubId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, String filter, long timeout) throws AMPSException {
        return this.deltaSubscribe(messageHandler, topic, filter, Message.Options.None, timeout);
    }

    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.deltaSubscribe(messageHandler, topic, null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(CommandId subscriptionId) throws DisconnectedException {
        this.lock.lock();
        try {
            this.unsubscribeInternal(subscriptionId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unsubscribeInternal(CommandId subscriptionId) throws DisconnectedException {
        CommandId id = CommandId.nextIdentifier();
        if (subscriptionId != null && this._routes.removeRoute(subscriptionId)) {
            this.message.reset();
            this.message.setCommand(4);
            this.message.setCommandId(id);
            this.message.setSubId(subscriptionId);
            this.subscriptionManager.unsubscribe(subscriptionId);
            this.sendInternal(this.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() throws DisconnectedException {
        CommandId id = CommandId.nextIdentifier();
        this.lock.lock();
        try {
            this.message.reset();
            this.message.setCommand(4);
            this.message.setCommandId(id);
            this.message.setSubId("all");
            this.subscriptionManager.clear();
            this.sendInternal(this.message);
        }
        finally {
            this.lock.unlock();
        }
    }

    public MessageStream sow(String topic, String filter) throws AMPSException {
        return this.execute(new Command("sow").setTopic(topic).setFilter(filter).setBatchSize(10));
    }

    public MessageStream sow(String topic) throws AMPSException {
        return this.execute(new Command("sow").setTopic(topic).setBatchSize(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sow(MessageHandler messageHandler, String topic, String filter, String orderBy, String bookmark, int batchSize, int topN, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this.executeAsyncNoLock(this.command.reset(8).setTopic(topic).setFilter(filter).setOrderBy(orderBy).setOptions(options).setBookmark(bookmark).setBatchSize(batchSize).setTopN(topN).setTimeout(timeout), messageHandler);
            CommandId commandId = this.command.getCommandId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sow(MessageHandler messageHandler, String topic, String filter, int batchSize, String options, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, filter, null, null, batchSize, -1, options, timeout);
    }

    public CommandId sow(MessageHandler messageHandler, String topic, String filter, int batchSize, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, filter, batchSize, Message.Options.None, timeout);
    }

    public CommandId sow(MessageHandler messageHandler, String topic, int batchSize, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, null, batchSize, timeout);
    }

    public CommandId sow(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, null, 10, timeout);
    }

    public MessageStream sowAndSubscribe(String topic, String filter) throws AMPSException {
        return this.execute(new Command("sow_and_subscribe").setTopic(topic).setFilter(filter).setBatchSize(10));
    }

    public MessageStream sowAndSubscribe(String topic) throws AMPSException {
        return this.execute(new Command("sow_and_subscribe").setTopic(topic).setBatchSize(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, String orderBy, String bookmark, int batchSize, int topN, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this.executeAsyncNoLock(this.command.reset(256).setTopic(topic).setFilter(filter).setOrderBy(orderBy).setOptions(options).setBookmark(bookmark).setBatchSize(batchSize).setTopN(topN).setTimeout(timeout), messageHandler);
            CommandId commandId = this.command.getCommandId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, String options, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, filter, null, null, batchSize, -1, options, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, boolean oofEnabled, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, filter, null, null, batchSize, -1, oofEnabled ? "oof" : null, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, filter, batchSize, false, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, int batchSize, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, null, batchSize, false, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, null, 10, false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, String orderBy, int batchSize, int topN, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this.executeAsyncNoLock(this.command.reset(1024).setTopic(topic).setFilter(filter).setOrderBy(orderBy).setOptions(options).setBatchSize(batchSize).setTopN(topN).setTimeout(timeout), messageHandler);
            CommandId commandId = this.command.getCommandId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, boolean oofEnabled, boolean sendEmpties, String options, long timeout) throws AMPSException {
        String opts = options;
        if (oofEnabled) {
            String string = opts = opts == null ? "oof" : opts + ",oof";
        }
        if (!sendEmpties) {
            opts = opts == null ? "no_empties" : opts + ",no_empties";
        }
        return this.sowAndDeltaSubscribe(messageHandler, topic, filter, null, batchSize, -1, opts, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, boolean oofEnabled, boolean sendEmpties, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, filter, batchSize, oofEnabled, sendEmpties, null, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, filter, batchSize, false, true, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, int batchSize, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, null, batchSize, false, true, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, null, 10, false, true, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowDelete(MessageHandler messageHandler, String topic, String filter, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this.executeAsyncNoLock(this.command.reset(32).setTopic(topic).setFilter(filter).addAckType(32).setOptions(options).setTimeout(timeout), messageHandler);
            CommandId commandId = this.command.getCommandId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sowDelete(MessageHandler messageHandler, String topic, String filter, long timeout) throws AMPSException {
        return this.sowDelete(messageHandler, topic, filter, null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sowDelete(String topic, String filter, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            Message message = this.execute(this.command.reset(32).addAckType(32).setTopic(topic).setFilter(filter).setTimeout(timeout)).next();
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowDeleteByKeys(MessageHandler messageHandler, String topic, String keys, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this.executeAsyncNoLock(this.command.reset(32).setTopic(topic).setSOWKeys(keys).addAckType(32).setTimeout(timeout), messageHandler);
            CommandId commandId = this.command.getCommandId();
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowDeleteByData(MessageHandler messageHandler, String topic, String data, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            CommandId commandId = this.executeAsyncNoLock(this.command.reset(32).addAckType(32).setTopic(topic).setData(data).setTimeout(timeout), messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFlush() throws DisconnectedException, TimedOutException {
        if (this.publishStore == null) {
            try {
                this.lock.lock();
                this.message.reset();
                CommandId id = CommandId.nextIdentifier();
                this.message.setCommandId(id);
                this.message.setAckType(8);
                if (this.serverVersion >= 4000000) {
                    this.message.setCommand(131072);
                } else {
                    this.message.setCommand(1);
                    this.message.setTopic("/AMPS/devnull");
                }
                this.syncAckProcessing(id, this.message, 0L);
                return;
            }
            catch (NullPointerException e) {
                throw new DisconnectedException("not connected");
            }
            catch (AMPSException aMPSException) {
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.publishStore.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFlush(long timeout) throws DisconnectedException, TimedOutException {
        if (this.publishStore == null) {
            try {
                this.lock.lock();
                this.message.reset();
                CommandId id = CommandId.nextIdentifier();
                this.message.setCommandId(id);
                this.message.setAckType(8);
                if (this.serverVersion >= 4000000) {
                    this.message.setCommand(131072);
                } else {
                    this.message.setCommand(1);
                    this.message.setTopic("/AMPS/devnull");
                }
                this.syncAckProcessing(id, this.message, timeout);
                return;
            }
            catch (NullPointerException e) {
                throw new DisconnectedException("not connected");
            }
            catch (AMPSException aMPSException) {
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.publishStore.flush(timeout);
        }
    }

    public long flush() throws DisconnectedException {
        try {
            this.lock.lock();
            long l = this.transport.flush();
            return l;
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected");
        }
        finally {
            this.lock.unlock();
        }
    }

    public long flush(long timeout) throws DisconnectedException {
        try {
            this.lock.lock();
            long l = this.transport.flush(timeout);
            return l;
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this._version != null) {
            return this._version;
        }
        Client client = this;
        synchronized (client) {
            Enumeration<URL> urls;
            this._version = new String("unknown");
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                return this._version;
            }
            try {
                urls = cl.getResources("META-INF/MANIFEST.MF");
            }
            catch (IOException E) {
                return this._version;
            }
            if (urls == null) {
                return this._version;
            }
            URL url = null;
            while (urls.hasMoreElements()) {
                Manifest manifest;
                url = urls.nextElement();
                if (!url.toString().contains("amps_client.jar")) continue;
                try {
                    manifest = new Manifest(url.openStream());
                }
                catch (IOException E) {
                    return this._version;
                }
                Attributes attrs = manifest.getMainAttributes();
                this._version = attrs.getValue("Release-Version");
                break;
            }
            return this._version;
        }
    }

    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo ci = new ConnectionInfo();
        ci.put("client.uri", this.uri == null ? null : this.uri.toString());
        ci.put("client.name", this.name);
        ci.put("client.username", this.username);
        if (this.publishStore != null) {
            ci.put("publishStore.unpersistedCount", this.publishStore.unpersistedCount());
        }
        return ci;
    }

    private AckResponse syncAckProcessing(CommandId id, Message m, long timeout) throws DisconnectedException, BadFilterException, BadRegexTopicException, InvalidTopicException, SubscriptionAlreadyExistsException, TimedOutException, NameInUseException, RetryOperationException, AuthenticationException, NotEntitledException, SubidInUseException, CommandException, UnknownException {
        AckResponse ackResponse = new AckResponse();
        ackResponse.responded = false;
        this._acks.put(id, ackResponse);
        ackResponse.connectionVersion = this.sendInternal(m);
        try {
            long startTime;
            long now = startTime = System.currentTimeMillis();
            while (!(ackResponse.abandoned || ackResponse.responded || timeout != 0L && now - startTime > timeout)) {
                if (timeout > 0L) {
                    long remainingTime = timeout - (now - startTime);
                    if (remainingTime > 0L) {
                        this.ackReceived.await(remainingTime, TimeUnit.MILLISECONDS);
                    }
                } else {
                    this.ackReceived.await();
                }
                now = System.currentTimeMillis();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (ackResponse.responded) {
            if (ackResponse.state != 2) {
                if (m.getCommand() == 128 && this.publishStore != null) {
                    try {
                        this.publishStore.discardUpTo(ackResponse.sequence);
                    }
                    catch (AMPSException e) {
                        // empty catch block
                    }
                    if (this.haSequenceNumber < ackResponse.sequence + 1L) {
                        this.haSequenceNumber = ackResponse.sequence + 1L;
                    }
                }
                return ackResponse;
            }
            switch (ackResponse.reason) {
                case 2: {
                    throw new BadFilterException("Filter '" + m.getFilter() + "' is invalid.");
                }
                case 3: {
                    throw new BadRegexTopicException("Regular Expression Topic '" + m.getTopic() + "' is invalid.");
                }
                case 8: {
                    throw new InvalidTopicException();
                }
                case 4: {
                    throw new SubscriptionAlreadyExistsException("Subscription for command '" + m.getCommandId() + "' already exists.");
                }
                case 15: {
                    throw new SubidInUseException("Subscription with subscription id '" + m.getSubId() + "' already exists.");
                }
                case 9: {
                    throw new NameInUseException("Client name \"" + m.getClientName() + "\" is already in use.");
                }
                case 10: {
                    throw new AuthenticationException("Logon failed for user \"" + m.getUserId() + "\"");
                }
                case 11: {
                    throw new NotEntitledException("User \"" + this.username + "\" not entitled to topic \"" + m.getTopic() + "\".");
                }
                case 0: 
                case 16: {
                    throw new CommandException("Error from server: " + ackResponse.reasonText);
                }
            }
        } else {
            if (!ackResponse.abandoned) {
                throw new TimedOutException("timed out waiting for operation");
            }
            throw new DisconnectedException("Connection closed while waiting for operation.");
        }
        return ackResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSynchronousWaiters(int connectionVersion) {
        ArrayList<CommandId> removeList = new ArrayList<CommandId>();
        this.lock.lock();
        try {
            for (Map.Entry<CommandId, AckResponse> e : this._acks.entrySet()) {
                if (e.getValue().connectionVersion > connectionVersion) continue;
                e.getValue().abandoned = true;
                removeList.add(e.getKey());
            }
            for (CommandId commandId : removeList) {
                this._acks.remove(commandId);
            }
            this.ackReceived.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class StopWatch {
        private long _timeout = 0L;
        private long _start = 0L;

        public boolean check() {
            if (this._timeout == 0L) {
                return false;
            }
            long current = System.currentTimeMillis();
            return current - this._start > this._timeout;
        }

        public void start() {
            this._start = System.currentTimeMillis();
        }

        public void setTimeout(long timeout) {
            this._start = System.currentTimeMillis();
            this._timeout = timeout;
        }
    }

    class FailedWriteStoreReplayer
    implements Store.StoreReplayer {
        int _reason;
        int _replayCount;

        public FailedWriteStoreReplayer(int reason) {
            this._reason = reason;
            this._replayCount = 0;
        }

        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLen, byte[] data, long dataOffset, long dataLength, byte[] corId, long corIdOff, long corIdLen) {
            ++this._replayCount;
            Client.this._failedWriteHandler.failedWrite(index, operation, topic, topicOffset, topicLen, data, dataOffset, dataLength, corId, corIdOff, corIdLen, this._reason);
        }

        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLen, byte[] data, long dataOffset, long dataLength, byte[] corId, long corIdOff, long corIdLen, int expiration) {
            ++this._replayCount;
            Client.this._failedWriteHandler.failedWrite(index, operation, topic, topicOffset, topicLen, data, dataOffset, dataLength, corId, corIdOff, corIdLen, this._reason);
        }

        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLen, byte[] data, long dataOffset, long dataLength, int expiration, CommandId cmdId) {
            ++this._replayCount;
            Client.this._failedWriteHandler.failedWrite(index, operation, topic, topicOffset, topicLen, data, dataOffset, dataLength, null, 0L, 0L, this._reason);
        }

        public int replayCount() {
            return this._replayCount;
        }
    }

    class ClientStoreReplayer
    implements Store.StoreReplayer {
        Client client;

        public ClientStoreReplayer(Client c) {
            this.client = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLen, byte[] data, long dataOffset, long dataLen, byte[] corId, long corIdOff, long corIdLen) throws DisconnectedException {
            try {
                this.client.lock.lock();
                this.client.message.reset();
                this.client.message.setCommand(operation);
                this.client.message.getTopicRaw().set(topic, (int)topicOffset, (int)topicLen);
                this.client.message.getDataRaw().set(data, (int)dataOffset, (int)dataLen);
                this.client.message.getCorrelationIdRaw().set(corId, (int)corIdOff, (int)corIdLen);
                this.client.message.setAckType(4);
                this.client.message.setSequence(index);
                this.client.haSequenceNumber = index >= this.client.haSequenceNumber ? index + 1L : this.client.haSequenceNumber;
                this.client.transport.sendWithoutRetry(Client.this.message);
            }
            finally {
                this.client.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLen, byte[] data, long dataOffset, long dataLen, byte[] corId, long corIdOff, long corIdLen, int expiration) throws DisconnectedException {
            try {
                this.client.lock.lock();
                this.client.message.reset();
                this.client.message.setCommand(operation);
                this.client.message.getTopicRaw().set(topic, (int)topicOffset, (int)topicLen);
                this.client.message.getDataRaw().set(data, (int)dataOffset, (int)dataLen);
                this.client.message.getCorrelationIdRaw().set(corId, (int)corIdOff, (int)corIdLen);
                this.client.message.setExpiration(expiration);
                this.client.message.setSequence(index);
                this.client.message.setAckType(4);
                this.client.message.setSequence(index);
                this.client.haSequenceNumber = index >= this.client.haSequenceNumber ? index + 1L : this.client.haSequenceNumber;
                this.client.transport.sendWithoutRetry(Client.this.message);
            }
            finally {
                this.client.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLen, byte[] data, long dataOffset, long dataLen, int type, CommandId cmdId) throws DisconnectedException {
            try {
                this.client.lock.lock();
                this.client.message.reset();
                this.client.message.setCommand(operation);
                if (cmdId != null) {
                    this.client.message.setCommandId(cmdId);
                }
                this.client.message.getTopicRaw().set(topic, (int)topicOffset, (int)topicLen);
                if (type == 1) {
                    this.client.message.getDataRaw().set(data, (int)dataOffset, (int)dataLen);
                } else if (type == 2) {
                    this.client.message.getFilterRaw().set(data, (int)dataOffset, (int)dataLen);
                } else {
                    this.client.message.getSowKeysRaw().set(data, (int)dataOffset, (int)dataLen);
                }
                this.client.message.setAckType(36);
                this.client.message.setSequence(index);
                this.client.haSequenceNumber = index >= this.client.haSequenceNumber ? index + 1L : this.client.haSequenceNumber;
                this.client.transport.sendWithoutRetry(Client.this.message);
            }
            finally {
                this.client.lock.unlock();
            }
        }
    }

    class ClientHandler
    implements MessageHandler,
    TransportDisconnectHandler {
        Client client = null;
        CommandId key = new CommandId();

        ClientHandler(Client client2) {
            this.client = client2;
        }

        public void preInvoke(int connectionVersion) {
            this.client.cancelSynchronousWaiters(connectionVersion);
        }

        public void invoke(Message m) {
            int SOWMask = 24584;
            int PublishMask = 32833;
            try {
                int commandType = m.getCommand();
                if ((commandType & 0x6008) > 0) {
                    m.getQueryId(this.key);
                    Client.this._routes.deliverData(m, this.key);
                } else if ((commandType & 0x8041) > 0) {
                    Field subIds = m.getSubIdsRaw();
                    BookmarkField bookmark = m.getBookmarkRaw();
                    int index = 0;
                    while (index < subIds.length) {
                        int end;
                        for (end = index; end < subIds.length && subIds.buffer[subIds.position + end] != 44; ++end) {
                        }
                        this.key.set(subIds.buffer, subIds.position + index, end - index);
                        index = end + 1;
                        MessageHandler handler = Client.this._routes.findRoute(this.key);
                        if (handler == null) continue;
                        m.setSubId(this.key);
                        if (!bookmark.isNull()) {
                            if (Client.this.bookmarkStore.isDiscarded(m)) {
                                try {
                                    this.client.duplicateMessageHandler.invoke(m);
                                }
                                catch (Exception e) {
                                    Client.this.absorbedException(e);
                                }
                                continue;
                            }
                            Client.this.bookmarkStore.log(m);
                            try {
                                handler.invoke(m);
                            }
                            catch (Exception e) {
                                Client.this.absorbedException(e);
                            }
                            continue;
                        }
                        try {
                            handler.invoke(m);
                        }
                        catch (Exception e) {
                            Client.this.absorbedException(e);
                        }
                    }
                } else if (commandType == 65536) {
                    int ackType = m.getAckType();
                    Client.this._routes.deliverAck(m, ackType);
                    switch (ackType) {
                        case 4: {
                            this.persistedAck(m);
                            return;
                        }
                        case 8: {
                            this.processedAck(m);
                            return;
                        }
                    }
                } else {
                    if (m.getCommand() == 16) {
                        this.checkAndSendHeartbeat(true);
                        return;
                    }
                    if (Client.this._routes.deliverData(m) == 0) {
                        Client.this.lastChanceMessageHandler.invoke(m);
                    }
                }
                this.checkAndSendHeartbeat(false);
            }
            catch (Exception e) {
                this.client.absorbedException(e);
            }
        }

        private void checkAndSendHeartbeat(boolean force) {
            if (force || this.client.heartbeatTimer.check()) {
                try {
                    this.client.heartbeatTimer.start();
                    this.client.transport.sendWithoutRetry(this.client.beatMessage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processedAck(Message message) {
            if (message.getCommandId(this.key)) {
                Client.this.lock.lock();
                try {
                    AckResponse response = null;
                    response = (AckResponse)this.client._acks.remove(this.key);
                    if (response != null) {
                        response.state = message.getStatus();
                        response.reason = message.getReason();
                        response.reasonText = message.getReasonText();
                        response.username = message.getUserId();
                        response.password = message.getPassword();
                        response.serverVersion = message.getVersionAsInt();
                        response.sequence = message.getSequenceRaw().isNull() ? 0L : message.getSequence();
                        response.responded = true;
                        Client.this.ackReceived.signalAll();
                        return;
                    }
                }
                catch (Exception e) {
                    this.client.absorbedException(e);
                }
                finally {
                    Client.this.lock.unlock();
                }
                try {
                    Client.this.lastChanceMessageHandler.invoke(message);
                }
                catch (Exception e) {
                    this.client.absorbedException(e);
                }
                return;
            }
        }

        private void persistedAck(Message message) {
            BookmarkField bookmark;
            boolean handled = false;
            if (Client.this.publishStore != null) {
                int reason = message.getReason();
                if (reason == 1 || reason == 11) {
                    if (this.client._failedWriteHandler != null) {
                        try {
                            long sequence = message.getSequence();
                            FailedWriteStoreReplayer replayer = new FailedWriteStoreReplayer(reason);
                            Client.this.publishStore.replaySingle(replayer, sequence);
                            if (replayer.replayCount() > 0) {
                                handled = true;
                            }
                        }
                        catch (Exception e) {
                            this.client.absorbedException(e);
                        }
                    }
                } else if (message.getStatus() == 1) {
                    try {
                        LongField sequence = (LongField)message.getSequenceRaw();
                        if (sequence != null && !sequence.isNull()) {
                            handled = true;
                            Client.this.publishStore.discardUpTo(sequence.getValue());
                        }
                    }
                    catch (Exception e) {
                        this.client.absorbedException(e);
                    }
                }
            }
            if (Client.this.serverVersion >= 3080000 && Client.this.bookmarkStore != null && !handled && (bookmark = message.getBookmarkRaw()) != null && !bookmark.isNull() && bookmark.length > 1) {
                try {
                    handled = true;
                    Client.this.bookmarkStore.persisted(message.getSubIdRaw(), bookmark);
                }
                catch (AMPSException e) {
                    this.client.absorbedException(e);
                }
            }
            if (!handled) {
                try {
                    Client.this.lastChanceMessageHandler.invoke(message);
                }
                catch (Exception e) {
                    this.client.absorbedException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void invoke(Transport newTransport, Exception e_) {
            Transport oldTransport;
            block18: {
                block17: {
                    oldTransport = null;
                    try {
                        Client.this.lock.lock();
                        Client.this.broadcastConnectionStateChanged(0);
                        oldTransport = Client.this.transport;
                        TransportConnectionMeasurer measurer = new TransportConnectionMeasurer(newTransport);
                        Client.this.transport = measurer;
                        while (true) {
                            try {
                                Client.this._badTimeToHAPublish = true;
                                measurer.clear();
                                if (Client.this.disconnectHandler instanceof ClientDisconnectHandler2) {
                                    ((ClientDisconnectHandler2)((Object)Client.this.disconnectHandler)).invoke(this.client, e_);
                                } else {
                                    Client.this.disconnectHandler.invoke(this.client);
                                }
                            }
                            finally {
                                Client.this._badTimeToHAPublish = false;
                            }
                            if (!measurer.successfullyConnected()) {
                                this.client.absorbedException(new DisconnectedException("reconnect failed."));
                                Client.this.transport = oldTransport;
                                break block17;
                            }
                            try {
                                this.client.subscriptionManager.resubscribe(this.client);
                            }
                            catch (TimedOutException ex) {
                                this.client.absorbedException(ex);
                                continue;
                            }
                            catch (DisconnectedException ex) {
                                this.client.absorbedException(ex);
                                continue;
                            }
                            break;
                        }
                        Client.this.transport = oldTransport;
                        break block18;
                    }
                    catch (Exception e) {
                        this.client.absorbedException(e);
                        return;
                    }
                }
                Client.this.lock.unlock();
                return;
            }
            Client.this.lock.unlock();
            return;
            finally {
                Client.this.transport = oldTransport;
                Client.this.lock.unlock();
            }
        }

        class TransportConnectionMeasurer
        implements Transport {
            Transport _t;
            boolean _successfullyConnected = false;

            public TransportConnectionMeasurer(Transport underlying) {
                this._t = underlying;
            }

            public void clear() {
                this._successfullyConnected = false;
            }

            public boolean successfullyConnected() {
                return this._successfullyConnected;
            }

            public void connect(URI uri) throws ConnectionRefusedException, AlreadyConnectedException, InvalidURIException {
                this._t.connect(uri);
                this._successfullyConnected = true;
            }

            public void close() {
                this._t.close();
            }

            public void disconnect() {
                this._t.disconnect();
            }

            public void setMessageHandler(MessageHandler ml) {
                this._t.setMessageHandler(ml);
            }

            public void setDisconnectHandler(TransportDisconnectHandler dh) {
                this._t.setDisconnectHandler(dh);
            }

            public void setExceptionListener(ExceptionListener exceptionListener) {
                this._t.setExceptionListener(exceptionListener);
            }

            public void send(Message message) throws DisconnectedException {
                this._t.send(message);
            }

            public void sendWithoutRetry(Message message) throws DisconnectedException {
                this._t.sendWithoutRetry(message);
            }

            public Message allocateMessage() {
                return this._t.allocateMessage();
            }

            public long writeQueueSize() throws DisconnectedException {
                return this._t.writeQueueSize();
            }

            public long readQueueSize() throws DisconnectedException {
                return this._t.readQueueSize();
            }

            public long flush() throws DisconnectedException {
                return this._t.flush();
            }

            public long flush(long timeout) throws DisconnectedException {
                return this._t.flush(timeout);
            }

            public void handleCloseEvent(int failedVersion_, String message, Exception e) throws DisconnectedException, RetryOperationException {
                this._t.handleCloseEvent(failedVersion_, message, e);
            }

            public int getVersion() {
                return this._t.getVersion();
            }

            public void setReadTimeout(int readTimeoutMillis_) {
                this._t.setReadTimeout(readTimeoutMillis_);
            }

            public void setTransportFilter(TransportFilter tracer_) {
                this._t.setTransportFilter(tracer_);
            }
        }
    }

    public static final class Bookmarks {
        public static final String MOST_RECENT = "recent";
        public static final String EPOCH = "0";
        public static final String NOW = "0|1|";
    }

    public static final class Version {
        public static final int AMPS_1 = 65536;
        public static final int AMPS_2 = 131072;
        public static final int AMPS_3 = 196608;
    }

    static class AckResponse {
        public volatile int connectionVersion;
        public volatile int serverVersion;
        public volatile boolean responded;
        public volatile boolean abandoned;
        public volatile int state;
        public volatile int reason;
        public volatile String reasonText;
        public volatile String username;
        public volatile String password;
        public volatile long sequence;

        AckResponse() {
        }
    }
}

