/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.MemoryPublishStore;
import com.crankuptheamps.client.PublishStore;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.exception.TimedOutException;
import java.io.IOException;

public class HybridPublishStore
implements Store {
    protected PublishStore _fileStore;
    protected MemoryPublishStore _memoryStore;
    protected int _cap;
    protected String _path;
    protected int _lowWatermark = 0;
    protected long _lowestIndexInTheFile = 0L;

    public HybridPublishStore(String path, int cap) throws IOException, StoreException {
        this._fileStore = new PublishStore(path);
        this._memoryStore = new MemoryPublishStore(cap);
        this._cap = cap;
        this._lowWatermark = (int)((double)this._cap * 0.5);
        this._path = path;
    }

    public void setLowWatermark(int lowWatermark_) {
        if (lowWatermark_ < this._cap) {
            this._lowWatermark = lowWatermark_;
        }
    }

    public synchronized long getLowestUnpersisted() {
        if (this._fileStore.unpersistedCount() == 0L) {
            return this._memoryStore.getLowestUnpersisted();
        }
        return this._fileStore.getLowestUnpersisted();
    }

    public synchronized void discardUpTo(long index) throws StoreException {
        this._fileStore.discardUpTo(index);
        this._memoryStore.discardUpTo(index);
    }

    public void replay(Store.StoreReplayer replayer) throws StoreException, DisconnectedException {
        this._fileStore.replay(replayer);
        this._memoryStore.replay(replayer);
    }

    public synchronized long unpersistedCount() {
        return this._fileStore.unpersistedCount() + this._memoryStore.unpersistedCount();
    }

    public void replaySingle(Store.StoreReplayer replayer, long index) throws StoreException, DisconnectedException {
        if (index <= this._lowestIndexInTheFile) {
            this._fileStore.replaySingle(replayer, index);
        } else {
            this._memoryStore.replaySingle(replayer, index);
        }
    }

    public void store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] corId, long corIdOff, long corIdLen) throws StoreException {
        block4: {
            try {
                if (this._memoryStore.unpersistedCount() >= (long)this._cap) {
                    SwappingOutReplayer replayer = new SwappingOutReplayer(this, (int)this._memoryStore.unpersistedCount() - this._lowWatermark);
                    this._memoryStore.replay(replayer);
                    if (replayer.getErrors() == 0) {
                        this._memoryStore.discardUpTo(replayer.lastIndex());
                        this._lowestIndexInTheFile = replayer.lastIndex();
                    }
                }
                this._memoryStore.store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, corId, corIdOff, corIdLen);
            }
            catch (DisconnectedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] corId, long corIdOff, long corIdLen, int expiration) throws StoreException {
        block4: {
            try {
                if (this._memoryStore.unpersistedCount() >= (long)this._cap) {
                    SwappingOutReplayer replayer = new SwappingOutReplayer(this, (int)this._memoryStore.unpersistedCount() - this._lowWatermark);
                    this._memoryStore.replay(replayer);
                    if (replayer.getErrors() == 0) {
                        this._memoryStore.discardUpTo(replayer.lastIndex());
                        this._lowestIndexInTheFile = replayer.lastIndex();
                    }
                }
                this._memoryStore.store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, corId, corIdOff, corIdLen, expiration);
            }
            catch (DisconnectedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void store(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, int expiration, CommandId cmdId) throws StoreException {
        block4: {
            try {
                if (this._memoryStore.unpersistedCount() >= (long)this._cap) {
                    SwappingOutReplayer replayer = new SwappingOutReplayer(this, (int)this._memoryStore.unpersistedCount() - this._lowWatermark);
                    this._memoryStore.replay(replayer);
                    if (replayer.getErrors() == 0) {
                        this._memoryStore.discardUpTo(replayer.lastIndex());
                        this._lowestIndexInTheFile = replayer.lastIndex();
                    }
                }
                this._memoryStore.store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, expiration, cmdId);
            }
            catch (DisconnectedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public synchronized void flush() throws TimedOutException {
        if (this._memoryStore.unpersistedCount() == 0L && this._fileStore.unpersistedCount() == 0L) {
            return;
        }
        long current = this._memoryStore._endOfUsedList.sequenceNumber;
        boolean keepWaiting = true;
        while (keepWaiting) {
            boolean bl = this._memoryStore._usedList == null ? false : (keepWaiting = current >= this._memoryStore._usedList.sequenceNumber);
            if (!keepWaiting) {
                keepWaiting = this._fileStore._usedList == null ? false : current >= this._fileStore._usedList.sequenceNumber;
            }
            try {
                if (!keepWaiting) continue;
                this.wait();
            }
            catch (InterruptedException e) {}
        }
    }

    public synchronized void flush(long timeout) throws TimedOutException {
        if (this._memoryStore.unpersistedCount() == 0L && this._fileStore.unpersistedCount() == 0L) {
            return;
        }
        long current = this._memoryStore._endOfUsedList.sequenceNumber;
        boolean keepWaiting = true;
        long start = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        while (keepWaiting) {
            boolean bl = this._memoryStore._usedList == null ? false : (keepWaiting = current >= this._memoryStore._usedList.sequenceNumber);
            if (!keepWaiting) {
                keepWaiting = this._fileStore._usedList == null ? false : current >= this._fileStore._usedList.sequenceNumber;
            }
            try {
                long remaining = timeout - (end - start);
                if (keepWaiting) {
                    this.wait(remaining);
                }
                if ((end = System.currentTimeMillis()) - start < timeout) continue;
                throw new TimedOutException("Timed out waiting to flush publish store.");
            }
            catch (InterruptedException e) {
            }
        }
    }

    public void setResizeHandler(PublishStoreResizeHandler handler) {
        this._fileStore.setResizeHandler(handler);
        this._memoryStore.setResizeHandler(handler);
    }

    private static class SwappingOutReplayer
    implements Store.StoreReplayer {
        HybridPublishStore _store;
        int _entries;
        int _errorCount;
        long _lastIndex;

        private SwappingOutReplayer(HybridPublishStore store_, int entries_) {
            this._store = store_;
            this._entries = entries_;
        }

        public int getErrors() {
            return this._errorCount;
        }

        public long lastIndex() {
            return this._lastIndex;
        }

        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] corId, long corIdOff, long corIdLen) {
            if (this._entries > 0 && this._errorCount == 0) {
                try {
                    this._store._fileStore.store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, corId, corIdOff, corIdLen);
                    this._lastIndex = index;
                }
                catch (Exception e) {
                    ++this._errorCount;
                }
                --this._entries;
            }
        }

        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, byte[] corId, long corIdOff, long corIdLen, int expiration) {
            if (this._entries > 0 && this._errorCount == 0) {
                try {
                    this._store._fileStore.store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, corId, corIdOff, corIdLen, expiration);
                    this._lastIndex = index;
                }
                catch (Exception e) {
                    ++this._errorCount;
                }
                --this._entries;
            }
        }

        public void execute(long index, int operation, byte[] topic, long topicOffset, long topicLength, byte[] data, long dataOffset, long dataLength, int expiration, CommandId cmdId) {
            if (this._entries > 0 && this._errorCount == 0) {
                try {
                    this._store._fileStore.store(index, operation, topic, topicOffset, topicLength, data, dataOffset, dataLength, expiration, cmdId);
                    this._lastIndex = index;
                }
                catch (Exception e) {
                    ++this._errorCount;
                }
                --this._entries;
            }
        }
    }
}

