/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkRingBuffer;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Pool;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class LoggedBookmarkStore
implements BookmarkStore {
    static final byte ENTRY_BOOKMARK = 98;
    static final byte ENTRY_DISCARD = 100;
    static final byte ENTRY_PERSISTED = 112;
    HashMap<Field, Subscription> _subs = new HashMap();
    HashSet<Field> _noPersistedAcks = new HashSet();
    RandomAccessFile _file;
    boolean _recovering = false;
    Pool<Subscription> _pool;
    BookmarkStoreResizeHandler _resizeHandler = null;
    private int _serverVersion = 4000000;

    public LoggedBookmarkStore(String path) throws IOException {
        this(path, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggedBookmarkStore(String path, int targetNumberOfSubscriptions) throws IOException {
        this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
        this._file = new RandomAccessFile(path, "rw");
        try {
            this.recover();
        }
        catch (IOException ioex) {
            try {
                this._file.close();
            }
            catch (IOException ignoreTheCloseException) {
            }
            finally {
                this._file = null;
            }
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Field sub, byte entry, Field data) throws IOException {
        if (!this._recovering) {
            LoggedBookmarkStore loggedBookmarkStore = this;
            synchronized (loggedBookmarkStore) {
                this._file.writeByte(sub.length);
                this._file.write(sub.buffer, sub.position, sub.length);
                this._file.writeByte(entry);
                this._file.writeByte(data.length);
                this._file.write(data.buffer, data.position, data.length);
                this._file.writeByte(10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Field sub, byte entry, long data) throws IOException {
        if (!this._recovering) {
            LoggedBookmarkStore loggedBookmarkStore = this;
            synchronized (loggedBookmarkStore) {
                this._file.writeByte(sub.length);
                this._file.write(sub.buffer, sub.position, sub.length);
                this._file.writeByte(entry);
                this._file.writeLong(data);
                this._file.writeByte(10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws IOException {
        block28: {
            this._recovering = true;
            HashMap ids = new HashMap();
            HashMap removeMap = new HashMap();
            ArrayList<BookmarkField> removeRemoveList = new ArrayList<BookmarkField>();
            byte[] sub = new byte[255];
            byte[] bookmark = new byte[255];
            long lastGoodPosition = this._file.getFilePointer();
            try {
                while (lastGoodPosition < this._file.length()) {
                    ArrayList<BookmarkField> removeList;
                    Field subId = new Field();
                    BookmarkField bookmarkField = new BookmarkField();
                    long position = this._file.getFilePointer();
                    int subLen = this._file.readByte();
                    for (int i = 0; i < subLen; ++i) {
                        sub[i] = this._file.readByte();
                    }
                    subId.set(sub, 0, subLen);
                    HashMap<BookmarkField, Long> subscriptionMap = (HashMap<BookmarkField, Long>)ids.get(subId);
                    if (subscriptionMap == null) {
                        subscriptionMap = new HashMap<BookmarkField, Long>();
                        ids.put(subId.copy(), subscriptionMap);
                    }
                    if ((removeList = (ArrayList<BookmarkField>)removeMap.get(subId)) == null) {
                        removeList = new ArrayList<BookmarkField>();
                        removeMap.put(subId.copy(), removeList);
                    }
                    Subscription subscription = this.find(subId);
                    switch (this._file.readByte()) {
                        case -1: {
                            return;
                        }
                        case 98: {
                            byte len = this._file.readByte();
                            if (len == -1 || (long)len > this._file.length() - this._file.getFilePointer()) {
                                this._file.seek(position);
                                return;
                            }
                            this._file.read(bookmark, 0, len);
                            bookmarkField.set(bookmark, 0, len);
                            if (subscriptionMap.get(bookmarkField) != null) {
                                subscription.getMostRecent();
                                subscriptionMap.clear();
                            }
                            if (subscription.isDiscarded(bookmarkField)) break;
                            long addedIndex = subscription.log(bookmarkField);
                            subscriptionMap.put(bookmarkField.copy(), addedIndex);
                            break;
                        }
                        case 100: {
                            byte len = this._file.readByte();
                            if (len == -1 || (long)len > this._file.length() - this._file.getFilePointer()) {
                                this._file.seek(position);
                                return;
                            }
                            this._file.read(bookmark, 0, len);
                            bookmarkField.set(bookmark, 0, len);
                            Long subscriptionMapEntry = (Long)subscriptionMap.get(bookmarkField);
                            if (subscriptionMapEntry == null) break;
                            removeList.add(bookmarkField.copy());
                            subscription.discard(subscriptionMapEntry);
                            break;
                        }
                        case 112: {
                            byte len = this._file.readByte();
                            if (len == -1 || (long)len > this._file.length() - this._file.getFilePointer()) {
                                this._file.seek(position);
                                return;
                            }
                            this._file.read(bookmark, 0, len);
                            bookmarkField.set(bookmark, 0, len);
                            if (!subscriptionMap.containsKey(bookmarkField)) break;
                            long discardIndex = (Long)subscriptionMap.get(bookmarkField);
                            if (this._serverVersion >= 4000000) {
                                subscription.setLastPersisted(discardIndex);
                            } else {
                                subscription.persisted(discardIndex);
                            }
                            removeRemoveList.clear();
                            for (BookmarkField bf : removeList) {
                                Long subMapEntry = (Long)subscriptionMap.get(bf);
                                if (subMapEntry == null || subMapEntry > discardIndex) continue;
                                removeRemoveList.add(bf);
                            }
                            for (BookmarkField bf : removeRemoveList) {
                                removeList.remove(bf);
                                subscriptionMap.remove(bf);
                            }
                            break;
                        }
                        default: {
                            throw new IOException("Corrupt file found.");
                        }
                    }
                    this._file.readByte();
                    lastGoodPosition = this._file.getFilePointer();
                }
            }
            catch (IOException ex) {
                if (lastGoodPosition > 0L) {
                    this._file.seek(lastGoodPosition);
                    break block28;
                }
                throw ex;
            }
            finally {
                this._recovering = false;
            }
        }
    }

    public long log(Message message) throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        try {
            BookmarkField bookmark = message.getBookmarkRaw();
            Subscription sub = (Subscription)message.getSubscription();
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            this.write(subId, (byte)98, bookmark);
            if (sub == null) {
                sub = this.find(subId);
                message.setSubscription(sub);
            }
            long index = sub.log(bookmark);
            message.setBookmarkSeqNo(index);
            if (this._noPersistedAcks.contains(subId)) {
                this.persisted(subId, bookmark);
            }
            return index;
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging to bookmark store", ioex);
        }
    }

    public void discard(Field subId, long bookmarkSeqNo) throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        try {
            this.find(subId).discard(bookmarkSeqNo);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error discarding from bookmark store", ioex);
        }
    }

    public void discard(Message message) throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        try {
            long bookmark = message.getBookmarkSeqNo();
            Subscription sub = (Subscription)message.getSubscription();
            if (sub == null) {
                Field subId = message.getSubIdRaw();
                if (subId == null || subId.isNull()) {
                    subId = message.getSubIdsRaw();
                }
                sub = this.find(subId);
                message.setSubscription(sub);
            }
            sub.discard(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error discarding from bookmark store", ioex);
        }
    }

    public Field getMostRecent(Field subId) throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        try {
            if (this._serverVersion >= 4000000) {
                return this.find(subId).getMostRecentList();
            }
            return this.find(subId).getMostRecent();
        }
        catch (IOException ioex) {
            throw new AMPSException("Error getting most recent from bookmark store", ioex);
        }
    }

    public boolean isDiscarded(Message message) throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        try {
            BookmarkField bookmark = message.getBookmarkRaw();
            Subscription sub = (Subscription)message.getSubscription();
            if (sub == null) {
                Field subId = message.getSubIdRaw();
                if (subId == null || subId.isNull()) {
                    subId = message.getSubIdsRaw();
                }
                sub = this.find(subId);
                message.setSubscription(sub);
            }
            return sub.isDiscarded(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error checking is discarded in bookmark store", ioex);
        }
    }

    public void persisted(Field subId, long bookmark) throws AMPSException {
        try {
            if (this._serverVersion >= 4000000) {
                this.find(subId).setLastPersisted(bookmark);
            } else {
                this.find(subId).persisted(bookmark);
            }
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging persisted to bookmark store", ioex);
        }
    }

    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException {
        try {
            if (this._serverVersion >= 4000000) {
                this.find(subId).setLastPersisted(bookmark);
            } else {
                this.find(subId).persisted(bookmark);
            }
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging persisted to bookmark store", ioex);
        }
    }

    public void noPersistedAcks(Field subId) throws AMPSException {
        try {
            Subscription sub = this.find(subId);
            this._noPersistedAcks.add(subId.copy());
            sub.noPersistedAcks();
        }
        catch (IOException ioex) {
            throw new AMPSException("Error setting no persisted acks on bookmark store", ioex);
        }
    }

    public synchronized long getOldestBookmarkSeq(Field subId) throws AMPSException {
        long retVal = 0L;
        try {
            retVal = this.find(subId).getOldestBookmarkSeq();
        }
        catch (IOException ioex) {
            throw new AMPSException("Error getting oldest bookmark seq from bookmark store", ioex);
        }
        return retVal;
    }

    public void setResizeHandler(BookmarkStoreResizeHandler handler) {
        this._resizeHandler = handler;
        for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
            pairs.getValue().setResizeHandler(handler, this);
        }
    }

    private synchronized Subscription find(Field subId) throws IOException {
        Subscription s = this._subs.get(subId);
        if (s == null) {
            s = this._pool.get();
            s.init(subId, this);
            s.setResizeHandler(this._resizeHandler, this);
            if (this._serverVersion >= 4000000 || this._serverVersion < 3080000) {
                s.noPersistedAcks();
            }
            this._subs.put(subId.copy(), s);
        }
        return s;
    }

    public synchronized void purge() throws AMPSException {
        try {
            this._file.setLength(0L);
        }
        catch (IOException ioex) {
            throw new StoreException("Error truncating file", ioex);
        }
        this._subs = new HashMap();
        this._noPersistedAcks = new HashSet();
    }

    public synchronized void close() throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        try {
            this._file.close();
        }
        catch (IOException ioex) {
            throw new StoreException("Error closing file", ioex);
        }
        finally {
            this._file = null;
        }
    }

    public void setServerVersion(int version) {
        if (this._serverVersion == version) {
            return;
        }
        this._serverVersion = version;
        if (this._serverVersion >= 4000000 || this._serverVersion < 3080000) {
            for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
                pairs.getValue().noPersistedAcks();
            }
        } else {
            for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
                pairs.getValue().setPersistedAcks();
            }
        }
    }

    static class Subscription
    implements com.crankuptheamps.client.Subscription {
        Field _sub;
        private BookmarkField _lastPersisted;
        HashMap<Field, Long> _recovered = new HashMap();
        HashMap<Long, Long> _relocatedActiveBookmarks = new HashMap();
        BookmarkRingBuffer _ring = new BookmarkRingBuffer();
        HashMap<Long, Long> _publishers = new HashMap();
        LoggedBookmarkStore _parent;

        public void init(Field subscriptionId, LoggedBookmarkStore parent) throws IOException {
            this._sub = subscriptionId.copy();
            this._ring.setSubId(this._sub);
            this._parent = parent;
        }

        public synchronized long log(BookmarkField bookmark) throws IOException {
            Long recoveredValue = this._recovered.remove(bookmark);
            if (recoveredValue != null) {
                long index = this._ring.relog(recoveredValue, bookmark);
                this._relocatedActiveBookmarks.put(recoveredValue, index);
                return index;
            }
            return this._ring.log(bookmark);
        }

        public synchronized void discard(long index) throws IOException {
            long idx = index;
            Long newIndex = this._relocatedActiveBookmarks.remove(index);
            while (newIndex != null) {
                this._ring.discard(idx);
                idx = newIndex;
                newIndex = this._relocatedActiveBookmarks.remove(newIndex);
            }
            BookmarkRingBuffer.Entry entry = this._ring.getByIndex(idx);
            if (entry == null) {
                return;
            }
            this._parent.write(this._sub, (byte)100, entry.getBookmark());
            this._ring.discard(idx);
        }

        public synchronized boolean isDiscarded(BookmarkField bookmark) throws IOException {
            Long recoveredIndex = this._recovered.get(bookmark);
            if (recoveredIndex != null) {
                boolean active;
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(recoveredIndex);
                boolean bl = active = entry == null ? false : entry.isActive();
                if (active) {
                    return false;
                }
                if ((entry == null || entry.isPersisted() && !active) && this._ring.getStartIndex() == -1L) {
                    this._ring.discard(recoveredIndex);
                    this._parent.write(this._sub, (byte)100, bookmark);
                } else {
                    long newIndex = this._ring.relog(recoveredIndex, bookmark);
                    this._parent.write(this._sub, (byte)98, bookmark);
                    if (active) {
                        this._relocatedActiveBookmarks.put(recoveredIndex, newIndex);
                    }
                }
                this._recovered.remove(bookmark);
                return true;
            }
            long publisher = bookmark.getPublisherId();
            long sequence = bookmark.getSequenceNumber();
            if (!this._publishers.containsKey(publisher) || this._publishers.get(publisher) < sequence) {
                this._publishers.put(publisher, sequence);
                return false;
            }
            BookmarkRingBuffer.Entry entry = this._ring.find(bookmark);
            if (entry != null) {
                return !entry.isActive();
            }
            return true;
        }

        public synchronized Field getMostRecent() {
            this.updateRecovery();
            return this._ring.getLastDiscarded();
        }

        public synchronized Field getMostRecentList() {
            this.updateRecovery();
            BookmarkField lastDiscarded = this._ring.getLastDiscarded();
            boolean useLastDiscarded = lastDiscarded != null && !lastDiscarded.isNull();
            long lastDiscardedPub = 0L;
            long lastDiscardedSeq = 0L;
            boolean useLastPersisted = this._lastPersisted != null && !this._lastPersisted.isNull();
            long lastPersistedPub = 0L;
            long lastPersistedSeq = 0L;
            if (useLastPersisted) {
                lastPersistedPub = this._lastPersisted.getPublisherId();
                lastPersistedSeq = this._lastPersisted.getSequenceNumber();
            }
            if (useLastDiscarded) {
                if (this._ring.isEmpty() && useLastPersisted) {
                    useLastDiscarded = false;
                } else {
                    lastDiscardedPub = lastDiscarded.getPublisherId();
                    lastDiscardedSeq = lastDiscarded.getSequenceNumber();
                    if (useLastPersisted && lastDiscardedPub == lastPersistedPub) {
                        useLastPersisted = lastPersistedSeq < lastDiscardedSeq;
                        useLastDiscarded = !useLastPersisted;
                    }
                }
            }
            StringBuilder recentStr = new StringBuilder();
            if (useLastDiscarded) {
                recentStr.append(lastDiscarded.getValue(Charset.forName("ISO-8859-1").newDecoder()));
            }
            if (!useLastPersisted && !useLastDiscarded) {
                if (this._publishers.isEmpty()) {
                    this._lastPersisted.setValue("0", Charset.forName("ISO-8859-1").newEncoder());
                    return this._lastPersisted;
                }
                Iterator<Map.Entry<Long, Long>> it = this._publishers.entrySet().iterator();
                while (it.hasNext()) {
                    if (recentStr.length() > 0) {
                        recentStr.append(",");
                    }
                    Map.Entry<Long, Long> pairs = it.next();
                    long pubId = pairs.getKey();
                    long seq = pairs.getValue();
                    recentStr.append(pubId).append("|");
                    recentStr.append(seq).append("|");
                }
            }
            if (useLastPersisted) {
                if (recentStr.length() > 0) {
                    recentStr.append(",");
                }
                recentStr.append(this._lastPersisted.getValue(Charset.forName("ISO-8859-1").newDecoder()));
            }
            BookmarkField recentList = new BookmarkField();
            recentList.setValue(recentStr.toString(), Charset.forName("ISO-8859-1").newEncoder());
            return recentList;
        }

        private void updateRecovery() {
            this._recovered.clear();
            long end = this._ring.getEndIndex();
            for (long index = this._ring.setRecovery(); index < end; ++index) {
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(index);
                if (entry == null || entry._bookmark == null || entry._bookmark.isNull()) continue;
                this._recovered.put(entry.getBookmark(), index);
            }
        }

        public synchronized void persisted(long bookmark) throws IOException {
            BookmarkRingBuffer.Entry entry = this._ring.getByIndex(bookmark);
            if (entry == null) {
                return;
            }
            BookmarkField bookmarkField = entry.getBookmark();
            this._parent.write(this._sub, (byte)112, bookmarkField);
            this._ring.persisted(bookmark);
        }

        public synchronized void persisted(BookmarkField bookmark) throws IOException {
            if (bookmark == null || bookmark.isNull()) {
                return;
            }
            this._parent.write(this._sub, (byte)112, bookmark);
            this._ring.persisted(bookmark);
        }

        public synchronized void setLastPersisted(long bookmark) throws IOException {
            BookmarkRingBuffer.Entry entry = this._ring.getByIndex(bookmark);
            if (entry == null) {
                return;
            }
            BookmarkField bookmarkField = entry.getBookmark();
            this._parent.write(this._sub, (byte)112, bookmarkField);
            if (this._lastPersisted != null) {
                this._lastPersisted.reset();
            }
            this._lastPersisted = bookmarkField.copy();
        }

        public synchronized void setLastPersisted(BookmarkField bookmark) throws IOException {
            if (bookmark == null || bookmark.isNull()) {
                return;
            }
            if (!this._ring.persistedAcks() && this._lastPersisted != null && bookmark.getPublisherId() == this._lastPersisted.getPublisherId() && bookmark.getSequenceNumber() <= this._lastPersisted.getSequenceNumber()) {
                return;
            }
            if (this._lastPersisted != null) {
                this._lastPersisted.reset();
            }
            this._parent.write(this._sub, (byte)112, bookmark);
            this._lastPersisted = bookmark.copy();
        }

        public synchronized void noPersistedAcks() {
            this._ring.noPersistedAcks();
        }

        public synchronized void setPersistedAcks() {
            this._ring.setPersistedAcks();
        }

        public synchronized long getOldestBookmarkSeq() {
            return this._ring.getStartIndex();
        }

        public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
            this._ring.setResizeHandler(handler, store);
        }
    }
}

