/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.Command;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.SubscriptionManager;
import com.crankuptheamps.client.exception.AMPSException;
import java.util.HashMap;

public class MemorySubscriptionManager
implements SubscriptionManager {
    static long DefaultResubscriptionTimeout = 10000L;
    private HashMap<CommandId, SubscriptionInfo> _active = new HashMap();
    boolean _resubscribing = false;

    public void subscribe(MessageHandler messageHandler, int command, CommandId subId, String topic, String filter, String bookmark, String options, int batchSize) {
        this._active.put(subId, new SubscriptionInfo(messageHandler, command, subId, topic, filter, bookmark, options, batchSize));
    }

    public void unsubscribe(CommandId subId) {
        if (!this._resubscribing) {
            this._active.remove(subId);
        }
    }

    public void clear() {
        this._active.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resubscribe(Client client) throws AMPSException {
        this._resubscribing = true;
        try {
            for (SubscriptionInfo si : this._active.values()) {
                si.resubscribe(client);
            }
        }
        finally {
            this._resubscribing = false;
        }
    }

    public static void setDefaultResubscriptionTimeout(long timeout) {
        DefaultResubscriptionTimeout = timeout;
    }

    static class SubscriptionInfo {
        Message _message = null;
        MessageHandler _handler;
        int _command;
        CommandId _subId;
        String _topic;
        String _filter;
        String _bookmark;
        String _options;
        int _batchSize;

        SubscriptionInfo(MessageHandler messageHandler, int command, CommandId subId, String topic, String filter, String bookmark, String options, int batchSize) {
            this._handler = messageHandler;
            this._command = command;
            this._subId = subId;
            this._topic = topic;
            this._filter = filter;
            this._bookmark = bookmark;
            this._options = options;
        }

        void resubscribe(Client client) throws AMPSException {
            Command cmd = new Command(this._command).setCommandId(this._subId).setQueryId(this._subId).setTopic(this._topic).setSubId(this._subId).setBatchSize(this._batchSize).setFilter(this._filter).setOptions(this._options);
            if (this._bookmark != null) {
                cmd.setBookmark("recent");
            }
            client.executeAsync(cmd, this._handler);
        }
    }
}

