/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.DefaultDisconnectHandler;
import com.crankuptheamps.client.DefaultMessageHandler;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.ProtocolParser;
import com.crankuptheamps.client.TCPTransport;
import com.crankuptheamps.client.TransportDisconnectHandler;
import com.crankuptheamps.client.TransportFilter;
import com.crankuptheamps.client.URIProperties;
import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.ConnectionRefusedException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.InvalidURIException;
import com.crankuptheamps.client.exception.RetryOperationException;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TCPTransportImpl {
    private URI _addr;
    protected SocketChannel _socket = null;
    public final Lock _lock = new ReentrantLock();
    volatile int _connectionVersion = 0;
    private volatile boolean _disconnecting = false;
    private Protocol _messageType = null;
    private MessageHandler _onMessage = DefaultMessageHandler.instance;
    private TransportDisconnectHandler _onDisconnect = DefaultDisconnectHandler.instance;
    private TCPReaderThread _readerThread = null;
    private ExceptionListener _exceptionListener = null;
    private Properties _properties = null;
    private Selector _selector = null;
    private int _readTimeout = 0;
    protected TransportFilter _filter;

    public TCPTransportImpl(Protocol messageType, Properties properties, TransportFilter filter) {
        this._messageType = messageType;
        this._properties = properties;
        this._filter = filter;
    }

    public void setMessageHandler(MessageHandler h) {
        this._onMessage = h;
    }

    public void setDisconnectHandler(TransportDisconnectHandler h) {
        this._onDisconnect = h;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this._exceptionListener = exceptionListener;
    }

    public void setTransportFilter(TransportFilter filter) {
        this._filter = filter;
    }

    public void connect(URI addr) throws ConnectionRefusedException, AlreadyConnectedException, InvalidURIException {
        this._lock.lock();
        this._disconnecting = false;
        Thread.interrupted();
        try {
            if (this._addr != null) {
                throw new AlreadyConnectedException("Already connected to AMPS at " + this._addr.getHost() + ":" + this._addr.getPort() + "\n");
            }
            this._socket = this.createSocket();
            URIProperties properties = new URIProperties(addr);
            if (this._properties != null) {
                properties.putAll((Map<?, ?>)this._properties);
            }
            this.applySocketProperties(properties);
            this._socket.connect(new InetSocketAddress(addr.getHost(), addr.getPort()));
            while (!this._socket.finishConnect()) {
                Thread.yield();
            }
            if (this._selector != null) {
                this._selector.close();
            }
            try {
                this._selector = Selector.open();
            }
            catch (IOException ioex) {
                this._selector = null;
                ioex.printStackTrace();
            }
            this._readerThread = new TCPReaderThread(this, this._messageType);
            this._addr = addr;
            ++this._connectionVersion;
        }
        catch (ClosedByInterruptException e) {
            Thread.interrupted();
            throw new ConnectionRefusedException("Interrupted, but please try again.", e);
        }
        catch (IOException ioex) {
            throw new ConnectionRefusedException("Unable to connect to AMPS at " + addr.getHost() + ":" + addr.getPort(), ioex);
        }
        catch (IllegalArgumentException iaex) {
            throw new InvalidURIException("Error setting socket options", iaex);
        }
        finally {
            this._lock.unlock();
        }
    }

    protected SocketChannel createSocket() throws IOException {
        SocketChannel socket = SocketChannel.open();
        socket.configureBlocking(false);
        return socket;
    }

    private void applySocketProperties(Properties properties_) throws SocketException, InvalidURIException {
        Socket s = this._socket.socket();
        s.setKeepAlive(true);
        s.setSoLinger(true, 10);
        if (properties_ == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties_.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ("tcp_keepalive".equals(key)) {
                if ("false".equals(value)) {
                    s.setKeepAlive(false);
                    continue;
                }
                if ("true".equals(value)) {
                    s.setKeepAlive(true);
                    continue;
                }
                throw new InvalidURIException("Invalid value for tcp_keepalive.");
            }
            if ("tcp_sndbuf".equals(key)) {
                try {
                    int sndbuf = Integer.parseInt((String)value);
                    s.setSendBufferSize(sndbuf);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_sndbuf.");
                }
            }
            if ("tcp_rcvbuf".equals(key)) {
                try {
                    int rcvbuf = Integer.parseInt((String)value);
                    s.setReceiveBufferSize(rcvbuf);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_rcvbuf.");
                }
            }
            if ("tcp_linger".equals(key)) {
                try {
                    int linger = Integer.parseInt((String)value);
                    if (linger == -1) {
                        s.setSoLinger(false, 0);
                        continue;
                    }
                    s.setSoLinger(true, linger);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidURIException("Invalid value for tcp_linger.");
                }
            }
            if ("tcp_nodelay".equals(key)) {
                if ("false".equals(value)) {
                    s.setTcpNoDelay(false);
                    continue;
                }
                if ("true".equals(value)) {
                    s.setTcpNoDelay(true);
                    continue;
                }
                throw new InvalidURIException("Invalid value for tcp_nodelay.");
            }
            throw new InvalidURIException("Unrecognized URI parameter `" + key + "'");
        }
    }

    private void _disconnect() {
        try {
            if (this._addr != null) {
                this._readerThread.stopThread();
                this._socket.close();
                if (!this._readerThread.equals(Thread.currentThread())) {
                    this._readerThread.interrupt();
                    this._readerThread.join();
                }
                this._selector.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._addr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this._lock.lock();
        try {
            this._disconnecting = true;
            this._disconnect();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void send(ByteBuffer buf) throws DisconnectedException {
        try {
            this._filter.outgoing(buf);
            while (buf.hasRemaining()) {
                this._socket.write(buf);
            }
        }
        catch (NullPointerException ioex) {
            throw new DisconnectedException("Socket error while sending message.");
        }
        catch (IOException ioex) {
            throw new DisconnectedException("Socket error while sending message.");
        }
    }

    public Socket socket() {
        try {
            return this._socket.socket();
        }
        catch (Exception e) {
            return null;
        }
    }

    public long writeQueueSize() {
        return 0L;
    }

    public long readQueueSize() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long flush() {
        this._lock.lock();
        try {
            long l = 0L;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long flush(long timeout) {
        this._lock.lock();
        try {
            long l = 0L;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCloseEvent(int failedVersion, String message, Exception e_) throws RetryOperationException, DisconnectedException {
        this._onDisconnect.preInvoke(failedVersion);
        if (this._readerThread != null && !this._readerThread.equals(Thread.currentThread())) {
            this._lock.lock();
        } else {
            try {
                while (!this._lock.tryLock(100L, TimeUnit.MILLISECONDS)) {
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new DisconnectedException("Reconnect is in progress in send thread.");
                }
            }
            catch (InterruptedException e) {
                throw new DisconnectedException("Reconnect already in progress in send thread.");
            }
        }
        try {
            if (this._disconnecting) {
                throw new DisconnectedException("Disconnect in progress.");
            }
            if (failedVersion != this._connectionVersion) {
                throw new RetryOperationException("A new connection is available.");
            }
            try {
                this._socket.socket().setSoLinger(true, 0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this._disconnect();
            }
            catch (Exception ex) {
                // empty catch block
            }
            TCPTransport t = TCPTransport.createTransport(this._messageType);
            t._impl = this;
            try {
                this._onDisconnect.invoke(t, new DisconnectedException(message, e_));
            }
            catch (Exception e) {
                throw new DisconnectedException("Disconnect handler threw an exception", e);
            }
        }
        finally {
            this._lock.unlock();
        }
        if (this._connectionVersion == failedVersion) {
            throw new DisconnectedException("A disconnect occured, and no disconnect handler successfuly reconnected.");
        }
        throw new RetryOperationException("Reconnect successful; retry the operation.");
    }

    public void setReadTimeout(int readTimeoutMillis_) {
        this._readTimeout = readTimeoutMillis_;
    }

    static class TCPReaderThread
    extends Thread {
        TCPTransportImpl transport = null;
        Protocol messageType = null;
        boolean stopped = false;

        TCPReaderThread(TCPTransportImpl transport, Protocol messageType) {
            this.transport = transport;
            this.messageType = messageType;
            this.stopped = false;
            this.setDaemon(TCPTransport.isDaemon());
            this.start();
        }

        public void stopThread() {
            this.stopped = true;
        }

        public void run() {
            this.setName(String.format("AMPS Java Client Background Reader Thread %d", Thread.currentThread().getId()));
            ByteBuffer rfifo = ByteBuffer.allocate(16384);
            ProtocolParser protocolParser = this.messageType.getMessageStream();
            Selector selector = this.transport._selector;
            while (!this.stopped) {
                try {
                    int currentVersion = this.transport._connectionVersion;
                    try {
                        int readBytes = this.transport._socket.read(rfifo);
                        if (readBytes == -1) {
                            String message = "The remote server has closed the connection.";
                            this.transport.handleCloseEvent(currentVersion, message, new DisconnectedException(message));
                            return;
                        }
                        if (readBytes == 0) {
                            Iterator<SelectionKey> keyIterator = selector.selectedKeys().iterator();
                            while (keyIterator.hasNext()) {
                                keyIterator.next();
                                keyIterator.remove();
                            }
                            this.transport._socket.register(selector, 1);
                            selector.select(this.transport._readTimeout);
                            if (this.transport._readTimeout == 0 || selector.selectedKeys().size() != 0) continue;
                            String message = String.format("No activity after %d milliseconds; connection closed by client.", this.transport._readTimeout);
                            this.transport.handleCloseEvent(currentVersion, message, new DisconnectedException(message));
                            return;
                        }
                    }
                    catch (ClosedSelectorException cse) {
                        return;
                    }
                    catch (IOException ioex) {
                        if (!this.stopped) {
                            this.transport.handleCloseEvent(currentVersion, "Exception while reading", ioex);
                        }
                        return;
                    }
                    rfifo.flip();
                    if (rfifo.remaining() >= 4) {
                        int size = rfifo.getInt(rfifo.position());
                        this.transport._filter.incoming(rfifo);
                        while (rfifo.remaining() - 4 >= size) {
                            block17: {
                                size = rfifo.getInt();
                                try {
                                    protocolParser.process(rfifo, size, this.transport._onMessage);
                                }
                                catch (Exception e) {
                                    if (this.transport._exceptionListener == null) break block17;
                                    this.transport._exceptionListener.exceptionThrown(e);
                                }
                            }
                            if (rfifo.remaining() < 4) break;
                            size = rfifo.getInt(rfifo.position());
                        }
                        if (rfifo.capacity() < size + 4) {
                            int newSize;
                            for (newSize = rfifo.capacity(); newSize < size + 4; newSize *= 2) {
                            }
                            ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
                            newBuffer.put(rfifo);
                            rfifo = newBuffer;
                            continue;
                        }
                        rfifo.compact();
                        continue;
                    }
                    rfifo.compact();
                    continue;
                }
                catch (Exception e) {
                    if (this.stopped || this.transport._exceptionListener == null) continue;
                    this.transport._exceptionListener.exceptionThrown(e);
                    continue;
                }
                break;
            }
            return;
        }
    }
}

