/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.spark;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.spark.CommandOption;
import com.crankuptheamps.spark.SparkCommand;
import java.util.UUID;

public class SOWCommand
extends SparkCommand {
    private String uriString = null;

    public SOWCommand(String name) {
        super(name);
        this.addOption(new CommandOption("topic", "topic to query", true));
        this.addOption(new CommandOption("filter", "content filter to use", false));
        this.addOption(new CommandOption("batchsize", "batch size to use during query", false));
        this.addOption(new CommandOption("bookmark", "bookmark for historical sow query", false));
        this.addOption(new CommandOption("orderby", "orderby expression for sow query", false));
        this.addOption(new CommandOption("topn", "only return top n records for sow query", false));
        this.addOption(new CommandOption("opts", "additional options: comma separated list of [oof,live,send_keys,no_empties]", false));
        this.addOption(new CommandOption("timeout", "timeout to wait for command to return in milliseconds", false));
        StringBuilder example = new StringBuilder(1024);
        example.append("  % ./spark sow -server localhost:9003 -topic Trades -filter \"/55 = 'Transport.123'\"\n");
        example.append("    Connects to the AMPS instance listening on port 9003");
        example.append("    and prints records in topic 'Trades' that have");
        example.append("    tag 55 set to 'Transport.123'");
        this.addExample(example.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(String[] argv) {
        this.parseArgs(argv, 1);
        String[] userAndServer = ((CommandOption)this.options.get("server")).getValue().split("@", 2);
        String server = userAndServer.length == 2 ? userAndServer[1] : userAndServer[0];
        String topic = ((CommandOption)this.options.get("topic")).getValue();
        String type = ((CommandOption)this.options.get("proto")).getValue();
        String filter = null;
        String bookmark = null;
        String orderBy = null;
        String opts = null;
        int topN = 0;
        int batchSize = 1;
        int timeout = 5000;
        if (!(type.equals("xml") || type.equals("fix") || type.equals("nvfix") || type.equals("amps") || type.equals("json"))) {
            this.badUsage("prot argument needs to be 'fix', 'xml', 'nvfix', 'amps', or 'json'.");
        }
        if (((CommandOption)this.options.get("filter")).hasValue()) {
            filter = ((CommandOption)this.options.get("filter")).getValue();
        }
        if (((CommandOption)this.options.get("batchsize")).hasValue()) {
            batchSize = Integer.parseInt(((CommandOption)this.options.get("batchsize")).getValue());
        }
        if (((CommandOption)this.options.get("bookmark")).hasValue()) {
            bookmark = ((CommandOption)this.options.get("bookmark")).getValue();
        }
        if (((CommandOption)this.options.get("orderby")).hasValue()) {
            orderBy = ((CommandOption)this.options.get("orderby")).getValue();
        }
        if (((CommandOption)this.options.get("opts")).hasValue()) {
            opts = ((CommandOption)this.options.get("opts")).getValue();
        }
        if (((CommandOption)this.options.get("topn")).hasValue()) {
            topN = Integer.parseInt(((CommandOption)this.options.get("topn")).getValue());
        }
        if (((CommandOption)this.options.get("timeout")).hasValue()) {
            timeout = Integer.parseInt(((CommandOption)this.options.get("timeout")).getValue());
        }
        String userId = userAndServer.length == 2 ? userAndServer[0] : System.getProperty("user.name");
        String clientName = "spark-sow-" + userId + "-" + UUID.randomUUID().toString();
        Client client = new Client(clientName, 131072);
        SOWCommandHandler handler = new SOWCommandHandler();
        client.setDisconnectHandler(handler);
        try {
            this.uriString = "tcp://" + userId + "@" + server + "/" + type;
            client.connect(this.uriString);
            client.logon(5000L, this.createAuthenticator(this.uriString));
        }
        catch (ConnectionException e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unable to connect to AMPS (" + e + ").");
            System.exit(1);
        }
        try {
            SOWCommandHandler e = handler;
            synchronized (e) {
                Message message = client.allocateMessage();
                message.setCommand(8);
                CommandId id = CommandId.nextIdentifier();
                message.setCommandId(id);
                message.setQueryId(id);
                message.setAckType(8);
                message.setTopic(topic);
                message.setBatchSize(batchSize);
                if (topN > 0) {
                    message.setTopN(topN);
                }
                if (filter != null) {
                    message.setFilter(filter);
                }
                if (orderBy != null) {
                    message.setOrderBy(orderBy);
                }
                if (opts != null) {
                    message.setOptions(opts);
                }
                if (bookmark != null) {
                    message.setBookmark(bookmark);
                }
                client.send(handler, message, timeout);
                try {
                    handler.wait();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
        }
        catch (AMPSException cmdEx) {
            System.err.println("error executing query: " + cmdEx.toString());
        }
        client.close();
    }

    private static class SOWCommandHandler
    implements MessageHandler,
    ClientDisconnectHandler {
        public long messageCount = 0L;
        public long start = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Message m) {
            switch (m.getCommand()) {
                case 8192: {
                    this.start = System.currentTimeMillis();
                    break;
                }
                case 8: {
                    ++this.messageCount;
                    System.out.println(m.getData());
                    break;
                }
                case 16384: {
                    long elapsed = System.currentTimeMillis() - this.start;
                    System.err.format("Total messages received: %d (%.2f/s)%n", this.messageCount, 1000.0 * (double)this.messageCount / (double)elapsed);
                    SOWCommandHandler sOWCommandHandler = this;
                    synchronized (sOWCommandHandler) {
                        this.notifyAll();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Client client) {
            long elapsed = System.currentTimeMillis() - this.start;
            System.err.format("Disconnected: total messages received: %d (%.2f/s)%n", this.messageCount, 1000.0 * (double)this.messageCount / (double)elapsed);
            SOWCommandHandler sOWCommandHandler = this;
            synchronized (sOWCommandHandler) {
                this.notifyAll();
            }
        }
    }
}

