////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////
package com.crankuptheamps.client;

import java.nio.ByteBuffer;
import java.io.OutputStream;
import java.io.PrintStream;

/**
 * An implementation of TransportFilter for tracing message bytes
 * to an OutputStream such as System.err. To use, instantiate
 * and then pass to Transport's setTransportFilter, for example:
 *
 *   Client client = new Client(...);
 *   client.connect(...);
 *   client.getTransport().setTransportFilter(
 *       new TransportTraceFilter(System.err)
 *     );
 */
public class TransportTraceFilter implements TransportFilter
{

    PrintStream _stream;
    byte[] _temporaryBuffer;
    /**
     * Construct a TransportTraceFilter to trace messages on stream_.
     * @param stream_ The OutputStream to trace messages to.
     */
    public TransportTraceFilter(OutputStream stream_)
    {
        _stream = new PrintStream(stream_);
    }
    protected void print(String prefix, ByteBuffer data)
    {
        _stream.print(prefix);
        if(data.hasArray())
        {
            _stream.write(data.array(), 0, data.limit());
            _stream.println();
        }
        else
        {
            // The ByteBuffer has no underlying array, so we have to
            // copy out its data into another array before we can write it.
            int length = data.limit();
            int position = data.position();
            if(_temporaryBuffer == null || _temporaryBuffer.length <= length)
            {
                _temporaryBuffer = new byte[length];
            }
            data.get(_temporaryBuffer,0,length);
            data.position(position);
            _stream.write(_temporaryBuffer,0,length);
            _stream.println();
        }

    }
    @Override
    public void outgoing(ByteBuffer data)
    {
        print("OUTGOING ===> ", data);
    }

    @Override
    public void incoming(ByteBuffer data)
    {
        print("INCOMING ===> ", data);
    }

}
