////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

import java.io.UnsupportedEncodingException;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Message.Status;

public class StatusField extends Field
{
    protected static final String LATIN1       = "ISO-8859-1";
    protected static final byte   LATIN1_ZERO  = 48;

    private static byte[] ST_SUCCESS                  = null;
    private static byte[] ST_FAILURE                  = null;
    private static byte[] ST_RETRY                    = null;

    static
    {
        try
        {
            ST_SUCCESS                  = "success".getBytes(LATIN1);
            ST_FAILURE                  = "failure".getBytes(LATIN1);
            ST_RETRY                    = "retry".getBytes(LATIN1);
        }
        catch(UnsupportedEncodingException e)
        {
            //Absorb... these should never throw for ASCII
        }
    }

    public int getValue()
    {
        if(this.buffer != null)
        {
            return decodeStatus(this.buffer, this.position, this.length);
        }
        return Status.None;
    }

    public void setValue(int v)
    {
        if(v == 0)
        {
            reset();
            return;
        }
        switch (v)
        {
        case Status.Success:
            set(ST_SUCCESS);
            break;
        case Status.Failure:
            set(ST_FAILURE);
            break;
        case Status.Retry:
            set(ST_RETRY);
            break;
        default:
            reset();
            break;
        }
    }

    static final int decodeStatus(byte[] buffer, int pos, int len)
    {
        if(len == 7)
        {
            if(buffer[pos] == 's') return Message.Status.Success;
            return Message.Status.Failure;
        }
        else if(len==5)
        {
            return Message.Status.Retry;
        }
        return Message.Status.None;
    }
    static final public String encodeStatus(int s)
    {
        switch(s)
        {
        case Message.Status.Success:
            return "success";
        case Message.Status.Failure:
            return "failure";
        case Message.Status.Retry:
            return "retry";
        case Message.Status.None:
            return "none";
        default:
            return "none";
        }
    }

}

