////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;

import com.crankuptheamps.client.exception.ProtocolException;

public class ProtocolFactory
{

    private static Hashtable<String, String> registry= new Hashtable<String, String>();

    static
    {
        registry.put("amps", "com.crankuptheamps.client.JSONProtocol");
    }

    public static void register( String name, String msgType) throws ProtocolException
    {
        if (!registry.containsKey(name) )
        {
            registry.put(name, msgType);
        }
        else
        {
            throw new ProtocolException("'" + name + "' is already registred.");
        }
    }

    public static void unregister(String name) throws ProtocolException
    {
        if(registry.containsKey(name))
        {
            registry.remove(name);
        }
        else
        {
            throw new ProtocolException("'" + name
                                           + "' is not a known Protocol, can not unregister.");
        }
    }

    public static Protocol createProtocol(
        String name,
        Properties props) throws ProtocolException
    {
        // Guess at the protocol name
        String mtName = "com.crankuptheamps.client." + name.toUpperCase() + "Protocol";
        if(registry.containsKey(name))
        {
            mtName = registry.get(name);
        }
        try
        {
            Class<?> c = Class.forName(mtName);
            Constructor ctor = c.getConstructor(Properties.class);
            Protocol result = (Protocol) ctor.newInstance(props);
            return result;
        }
        catch (Exception e)
        {
            throw new ProtocolException("'" + name + "' is not a valid Protocol.");
        }
    }

}
