////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2015 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

package com.crankuptheamps.client.fields;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.zip.CRC32;

import com.crankuptheamps.client.CommandId;

public class BookmarkField extends StringField
{

    protected BookmarkField(byte[] buffer, int position, int length)
    {
        super(buffer, position, length);
    }

    public BookmarkField()
    {
    }

    public long getPublisherId()
    {
        long result = 0;
        for(int i = this.position; i < this.position + this.length; i++)
        {
            if( this.buffer[i] == (int)'|' )
            {
                break;
            }

            result *= 10;
            result += this.buffer[i] - 48;
        }
        return result;
    }

    public long getSequenceNumber()
    {
        long result = 0;
        int i = this.position;
        for(; i < this.position + this.length; i++)
        {
            if( this.buffer[i] == (int)'|' )
            {
                break;
            }
        }

        for(i = i+1; i < this.position + this.length; i++)
        {
            if( this.buffer[i] == (int)'|' )
            {
                break;
            }
            result *= 10;
            result += this.buffer[i] - 48;
        }

        return result;
    }

    private final CRC32 c = new CRC32();
    public int hashCode()
    {
        c.reset();
        c.update(buffer, position, length);
        return (int)c.getValue();
    }


    /**
     * Provides a way to duplicate this object and retain its specific type (and hashcode() implementation).
     */
    public Object clone()
    {
        byte[] copy = null;

        if (buffer != null) {
            copy = new byte[length];
            System.arraycopy(buffer, position, copy, 0, length);
        }
        return new BookmarkField(copy, 0, length);
    }

    // Override base class's copy() method appropriately, so we don't inadvertently mix
    // BookmarkFields and Fields up -- they have different hashCode implementations.
    public BookmarkField copy()
    {
        return (BookmarkField)clone();
    }

}

