package com.crankuptheamps.examples;

import java.lang.Thread;

import com.crankuptheamps.client.*;
import com.crankuptheamps.client.exception.*;

/** ConsoleSubscriber
*
* This is a minimalist way of subscribing to a topic in AMPS. The
* program flow is simple:
*
* * Connect to AMPS
* * Logon
* * Subscribe to all messages published on the "messages" topic 
* * Output the messages to the console
*
* This sample doesn't include error handling or connection
* retry logic.
*
* (c) 2014-2016 60East Technologies, Inc.  All rights reserved.
* This file is a part of the AMPS Evaluation Kit.
*/

public class ConsoleSubscriber {

   // The location of the AMPS server.
   private static final String uri_ = "tcp://127.0.0.1:9007/amps/json";

   /**
    * main method.
    * 
    */
   public static void main(String[] args)
   {
      System.out.println("Starting the console subscriber.");

      try (HAClient client = new HAClient("ConsoleSubscriber");) {
         // Create a custom server chooser
         DefaultServerChooser serverChooser = new DefaultServerChooser();
         serverChooser.add(uri_);

         // Set the server chooser for the HAClient
         client.setServerChooser(serverChooser);
         // connect to the AMPS server and logon
         client.connectAndLogon();
         System.out.println("Subscriber Connected");

         // subscribe to the messages topic with a timeout of 10 seconds.
         // when a message arrives, print the message.
         try (MessageStream ms = client.subscribe("messages").timeout(10000);) {
            int limit = 1;
            int count = 0;
            for (Message m : ms) {
               ++count;
               // message is null if call times out
               if (m == null)
                  break;
               System.out.println(m.getData());
               // ending subscription if we reach example limit
               if (count >= limit)
                  break;
            }
         }
      } catch (AMPSException e) {
         System.err.println(e.getLocalizedMessage());
         e.printStackTrace(System.err);

      }
   }
}
