﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AMPS.Client.Xaml;
using System.Data;
using System.Threading;
using System.ComponentModel;

namespace OrdView
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }


        // Since we have a large query to process, we don't 
        // want to run queries without an explicit command
        private void Update_Click(object sender, RoutedEventArgs e)
        {
            _filter.GetBindingExpression(TextBox.TextProperty).UpdateSource();
            this.Cursor = Cursors.Wait;
            var sub = (Subscription)this.Resources["MySubscription"];
            if (sub.Server == null || sub.Server.Hostname != _server.Text)
            {

                try
                {
                    ((Subscription)this.Resources["MySubscription"]).Server = new Server
                    {
                        Hostname = _server.Text,
                        Port = 9005,
                        MessageType = "nvfix"
                    };
                }
                catch (Exception ex)
                {
                    this.Cursor = Cursors.Arrow;
                    MessageBox.Show(ex.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Error);
                }
            }
            this.Cursor = Cursors.Arrow;   
        }

    }
}
